function info_struct = getAnalyticalSteadyStateWithDoppler(RAQR_config, E_RF, Temperature, vbs)

if ~exist('vbs', 'var') || isempty(vbs)
    vbs = 0; 
end

    epsilon_0   = 8.85e-12; 
    hbar        = 6.626e-34 / (2*pi); 
    c0          = physconst('LightSpeed'); 

    a0      = 5.2918e-11; 
    e       = 1.6e-19; 
    mu_MW   = 1443.45*e*a0; 
    mu_12   = 4.5022*e*a0;          

    % Extract parameters 

    lambda_p    = RAQR_config.lambda_p; 
    lambda_c    = RAQR_config.lambda_c; 

    gamma   = RAQR_config.gamma; 
    gamma_2 = RAQR_config.gamma_2; 
    gamma_3 = RAQR_config.gamma_3; 
    gamma_4 = RAQR_config.gamma_4; 
    gamma_c = RAQR_config.gamma_c; 
    
    Omega_c = RAQR_config.Omega_c; 
    Omega_p = RAQR_config.Omega_p; 

    Delta_c = RAQR_config.Delta_c; 
    Delta_p = RAQR_config.Delta_p; 
    Delta_l = RAQR_config.Delta_l; 

    Omega_RF = (E_RF*mu_MW)/(hbar); 

    
    NA      = 6.02e23; 
    M_Cs    = 132.9; 
    m_Cs    = (M_Cs/1e3)/NA; 
    kB      = getPhysicalConstant('Boltzmann'); 

    sigma_vx    = sqrt(kB*Temperature/m_Cs);  

    eps = 1e-6; 
    
    
    %% STEP 1: Evaluate the zero-Doppler steady-state 
    delta_p = Delta_p; 
    delta_c = Delta_c; 
    delta_l = Delta_l; 
    
    % Randomize the phases of Omega_p and Omega_c
    % omega_p = Omega_p*exp(1i*2*pi*rand()); 
    omega_p = Omega_p; 
    % omega_c = Omega_c*exp(1i*2*pi*rand()); 
    omega_c = Omega_c; 

    H0= [0,         conj(omega_p)/2,    0,                      0;                  ...
        omega_p/2,  -delta_p,           conj(omega_c)/2,        0;                  ...
        0,          omega_c/2,          -delta_p-delta_c,       conj(Omega_RF)/2;   ...
        0,          0,                  (Omega_RF)/2,           -delta_p-delta_c-delta_l]; 
    
    Gamma = diag([0, gamma_2, gamma_3, gamma_4]+gamma); 
    
    A0 = -1i*(kron(eye(4), H0) - kron(H0.', eye(4))) - (1/2)*(kron(Gamma, eye(4)) + kron(eye(4), Gamma)); 
    A0(1, 6)    = A0(1, 6) + gamma_2; 
    A0(1, 16)   = A0(1, 16) + gamma_4; 
    A0(6, 11)   = A0(6, 11) + gamma_3; 
    
    % Re-population 
    A0(1,1) = A0(1,1) + gamma; 
    A0(1,6) = A0(1,6) + gamma; 
    A0(1,11) = A0(1,11) + gamma; 
    A0(1,16) = A0(1,16) + gamma; 

    % Find the steady state solution x_ss that corresponds to the zero-eigenvector of A0, and ensure that <u4, x_ss> ==1
    N       = norm(A0, 'fro'); 
    u4      = N*eye(4); u4 = u4(:); 
    x_ss    = (A0'*A0 + u4*u4')\(N*u4);   % [Reference] 
    rho_ss  = reshape(x_ss, [4, 4]); 
    assert(abs(trace(rho_ss)-1) <= eps && norm(rho_ss-rho_ss', 'fro') <= eps); 
    
    %% STEP 2: Construct the v-propagator to enable the evaluation of rho_v for each Doppler velocity v  
    % Av has dimension [Hz]. 
    Av          = (2*pi*sigma_vx/lambda_p)*(-1i)*(kron(eye(4), diag([0, -1, -1, -1])) - kron(diag([0, -1, -1, -1]).', eye(4))); 
    Av          = Av + (-2*pi*sigma_vx/lambda_c)*(-1i)*(kron(eye(4), diag([0, 0, -1, -1])) - kron(diag([0, 0, -1, -1]).', eye(4))); 
    
    % Compute the pseudo-inverse of A0 
    [V, D] = eig(A0); 
    [~, order] = sort(abs(diag(D)), 'ascend'); 
    V = V(:, order);  % Note that the eigenvectors of A0 are not necessarily orthogonal. 
    d = diag(D); 
    d = d(order); 
    
    A0_pinv = V*diag([0; 1./d(2:end)]) / V;  % Compute the Moore-Penrose pseudo-inverse with the eigen-decomposition method 
    % ZJA note: This is also computable with SVD. 
    
    G = (A0_pinv)*Av;          % See my paper for the proof of this thing.  
    % vec_rho_v = (eye(16) + (vx/sigma_vx)*G)\rho_ss(:); 
    % rho_v = reshape(vec_rho_v, [4,4]); 
    

    % Compute the right eigenvectors and left eigenvectors of G 
    [R, D] = eig(G); 
    [~, order] = sort(abs(diag(D)), 'ascend'); 
    R = R(:, order); 
    d = diag(D); 
    lambdas_G = d(order); 
    
    % Right eigen-vector: G*R = R*diag(lambdas_G)
    % Left eigen-vector:  L*G = diag(lambdas_G)*L  
    L = inv(R); % Left eigen-vectors, arranged in row vectors   
    
    %% STEP 3: Compute the Doppler-averaged rho analytically. 
    vec_rho_d = zeros(16, 1); 
    for idx = 1:16 
        lam = lambdas_G(idx);
        
        if abs(lam) < eps
            coef = 1;
        else
            coef = (-1/lam)*getJ(-1/lam); % The function J(z) is defined in my paper.  
        end
    
        vec_rho_d = vec_rho_d + coef * R(:,idx) * (L(idx, :)*rho_ss(:)); 
    end
    
    rho_d = reshape(vec_rho_d, [4,4]); 
    assert(abs(trace(rho_d)-1) <= eps); 


    if vbs >= 2 && false 
        yyaxis left; 
        plot(vx_knots, imag(rho21Arr)); 
        xlabel('v_x (m/s)'); 
        ylabel('Imag(\rho_2_1)'); 
        yyaxis right; 
        plot(vx_knots, vx_probs); 
        ylabel('Probability'); 
        grid on; 
    end

    rho21       = rho_d(2, 1); 
    d           = RAQR_config.d; 
    N0          = RAQR_config.N0; 

    % Transmission coefficient of the probe light, Tp
    Tp_d = (20/log(10))*(-pi*d/lambda_p)*imag(-(2*N0*mu_12^2)/(epsilon_0*hbar*Omega_p)*(rho21)); 
    
    info_struct.rho_ss      = rho_d; 
    info_struct.Tp_ss       = Tp_d; 
    info_struct.sigma_vx    = sigma_vx; 


end

