function Tp_dB = getEITATSpectrum(RAQR_config, fDelta_c_arr, E_RF, Temperature, method)
% This function returns the EIT-AT spectrum of the finite-temperature Rydberg system 
% 

    if ~exist('method', 'var')
        method = "withDoppler";
        Temperature = 300; 
    end
    
    Nscan = length(fDelta_c_arr); 
    Tp_dB = zeros(size(fDelta_c_arr)); 
    
    parfor idx_scan = 1:Nscan
        fDelta_c                    = fDelta_c_arr(idx_scan); 
    
        temp_RAQR_config            = RAQR_config; 
        temp_RAQR_config.Delta_c    = 2*pi*fDelta_c;  
        
        if method == "ZeroTemperature"
            [rho_ss, Tp_ss]     = getSteadySolution(temp_RAQR_config, E_RF);
        
        elseif method == "withDoppler"
            info_struct         = getSteadySolutionWithDoppler(temp_RAQR_config, E_RF, Temperature);
            Tp_ss               = info_struct.Tp_ss; 
            
        elseif method == "Analytical"
            info_struct         = getAnalyticalSteadyStateWithDoppler(temp_RAQR_config, E_RF, Temperature); 
            Tp_ss               = info_struct.Tp_ss; 

        else
            error('Method %s not implemented.', method); 
        end

        Tp_dB(idx_scan) = Tp_ss; 
    end


end

