function vTransferMat = getMutualCouplingMatrix(freq, Nr)

c       = physconst("lightspeed");
lambda  = c/freq;
N       = Nr;
dx      = 0.49*lambda;

dipole_L        = lambda/2.3;
dipole_W        = lambda/100;
mydipole        = dipole;
mydipole.Length = dipole_L;
mydipole.Width  = dipole_W;
mydipole.TiltAxis   = "Z";
mydipole.Tilt       = 90;
% fmin = freq - 0.05*freq;
% fmax = freq + 0.05*freq;
% minX = 0.0001;          % Minimum value of reactance to achieve
% trim = 0.0005;          % The amount to shorten the length at each iteration
% resonant_dipole = dipole_tuner(mydipole,freq,fmin,fmax,minX,trim);


% Perform conjugate impedance matching on each Rx antenna terminal 
Z_resonant_dipole = impedance(mydipole, freq); 
Zc = real(Z_resonant_dipole); 

% ZL = conj(Z_resonant_dipole);  


% Create a dipole array with N dipoles 
resonant_dipole = mydipole; 
dipole_array = linearArray;
dipole_array.Element = resonant_dipole;
dipole_array.NumElements = N;
dipole_array.ElementSpacing = dx;

% Compute the s-parameters of this dipole array, evaluated at center freq. 
s = sparameters(dipole_array, freq, Zc);  
smat = s.Parameters; 

% convert s-parameters into normalized z-parameters 
zmat = (eye(N)+smat)/(eye(N)-smat); 

% Compute the linear transfer from OC voltage to actual load voltage. 
% Note that all the voltages are normalized by sqrt(Zc).  
zL = 1*ones(N, 1); % normalized load impedance 
vTransferMat = inv(eye(N)+zmat); 

end
