function [x_knots, x_probs] = getNormalQuadrature(n, method)
    
if ~exist('method', 'var') || isempty(method)
    method = "Uniform"; 
end

% Determine the separation points x_int 
if method == "Uniform"
    x_int = 3.5*linspace(-1, 1, n-1); 

elseif method == "DenseCenter"
    p_int = linspace(0, 1, n+1);  
    x_int = norminv(p_int(2:n), 0, 1); 

else
    error('Method %s not implemented.\n', method); 
end

cdfs = cdf('Normal', x_int, 0, 1); 
x_probs = [cdfs(1), diff(cdfs), cdfs(1)];  % Length: n

% Compute the integral of x*p(x) for each interval defined by x_int. 
ints = [0, (1/sqrt(2*pi))*(-1)*exp(-x_int.^2/2), 0]; 
ints = diff(ints); 

x_knots = ints./x_probs; 

end

