function info_struct = getSteadySolutionWithDoppler(RAQR_config, E_RF, Temperature, vbs)

if ~exist('vbs', 'var') || isempty(vbs)
    vbs = 0; 
end

    epsilon_0   = 8.85e-12; 
    mu_0        = 4*pi*1e-7; 
    hbar        = 6.626e-34 / (2*pi); 
    c0          = physconst('LightSpeed'); 

    a0      = 5.2918e-11; 
    e       = 1.6e-19; 
    mu_MW   = 1443.45*e*a0; 
    mu_12   = 4.5022*e*a0;          

    % Extract parameters 
    d           = RAQR_config.d; 
    N0          = RAQR_config.N0; 
    lambda_p    = RAQR_config.lambda_p; 
    lambda_c    = RAQR_config.lambda_c; 

    gamma   = RAQR_config.gamma; 
    gamma_2 = RAQR_config.gamma_2; 
    gamma_3 = RAQR_config.gamma_3; 
    gamma_4 = RAQR_config.gamma_4; 
    gamma_c = RAQR_config.gamma_c; 
    
    Omega_c = RAQR_config.Omega_c; 
    Omega_p = RAQR_config.Omega_p; 

    Delta_c = RAQR_config.Delta_c; 
    Delta_p = RAQR_config.Delta_p; 
    Delta_l = RAQR_config.Delta_l; 

    Omega_RF = (E_RF*mu_MW)/(hbar); 

    
    NA      = 6.02e23; 
    M_Cs    = 132.9; 
    m_Cs    = (M_Cs/1e3)/NA; 
    kB      = getPhysicalConstant('Boltzmann'); 

    sigma_vx    = sqrt(kB*Temperature/m_Cs);  
    Nd          = 1501; 
    eps         = 1e-6; 
    
    

    [x_knots, vx_probs] = getNormalQuadrature(Nd); 
    vx_knots = sigma_vx * x_knots; 
    
    rho_ssArr = cell(Nd, 1); 

    for idx_d = 1:Nd
        vx      = vx_knots(idx_d); 
        delta_p = Delta_p + 2*pi*vx/lambda_p; 
        delta_c = Delta_c - 2*pi*vx/lambda_c; 
        delta_l = Delta_l; 
        
        % Randomize the phases of Omega_p and Omega_c
        % omega_p = Omega_p*exp(1i*2*pi*rand()); 
        omega_p = Omega_p; 
        % omega_c = Omega_c*exp(1i*2*pi*rand()); 
        omega_c = Omega_c; 

        H0= [0,         conj(omega_p)/2,    0,                      0;                  ...
            omega_p/2,  -delta_p,           conj(omega_c)/2,        0;                  ...
            0,          omega_c/2,          -delta_p-delta_c,       conj(Omega_RF)/2;   ...
            0,          0,                  (Omega_RF)/2,           -delta_p-delta_c-delta_l]; 
        
        Gamma = diag([gamma, gamma+gamma_2, gamma+gamma_3+gamma_c, gamma+gamma_4]); 
        
        A0 = -1i*(kron(eye(4), H0) - kron(H0.', eye(4))) - (1/2)*(kron(Gamma, eye(4)) + kron(eye(4), Gamma)); 
        A0(1, 6)    = A0(1, 6) + gamma_2; 
        A0(1, 16)   = A0(1, 16) + gamma_4; 
        A0(6, 11)   = A0(6, 11) + gamma_3; 

        % Re-population 
        A0(1,1) = A0(1,1) + gamma; 
        A0(1,6) = A0(1,6) + gamma; 
        A0(1,11) = A0(1,11) + gamma; 
        A0(1,16) = A0(1,16) + gamma; 

        
        % Find the steady state solution x_ss that corresponds to the zero-eigenvector of A0, and ensure that <u4, x_ss> ==1
        % 
        N  = norm(A0, 'fro'); 
        u4      = N*eye(4); u4 = u4(:); 
        x_ss    = (A0'*A0 + u4*u4')\(N*u4);   % [Reference] 
        rho_ss  = reshape(x_ss, [4, 4]); 
        
        assert(abs(trace(rho_ss)-1) <= eps); 
        rho_ssArr{idx_d} = rho_ss; 
    end

    rho_ss = zeros(4); 
    rho21Arr = zeros(1, Nd); 
    for idx_d = 1:Nd
        rho = rho_ssArr{idx_d}; 
        rho_ss = rho_ss + vx_probs(idx_d)*rho; 
        rho21Arr(idx_d) = rho(2, 1); 
    end

    if vbs >= 2
        yyaxis left; 
        plot(vx_knots, imag(rho21Arr)); 
        xlabel('v_x (m/s)'); 
        ylabel('Imag(\rho_2_1)'); 
        yyaxis right; 
        plot(vx_knots, vx_probs); 
        ylabel('Probability'); 
        grid on; 
    end
    assert(abs(trace(rho_ss)-1) <= eps); 

    % Transmission coefficient of the probe light, Tp
    Tp_ssArr = (20/log(10))*(-pi*d/lambda_p)*imag(-(2*N0*mu_12^2)/(epsilon_0*hbar*Omega_p)*(rho21Arr)); 
    
    Tp_ss = sum(Tp_ssArr.*vx_probs);  
    
    info_struct.rho_ss      = rho_ss; 
    info_struct.rho_ssArr   = rho_ssArr; 
    info_struct.Tp_ss       = Tp_ss; 
    info_struct.Tp_ssArr    = Tp_ssArr; 
    info_struct.vx_probs    = vx_probs;
    info_struct.vx_knots    = vx_knots; 
    info_struct.sigma_vx    = sigma_vx; 
    
end


