function ret = getTransmittedProbePower0(RAQR_config, method)
% This function provides various quantities about the steady-state
% coefficients. 

if ~exist('method', 'var')
    method = "Iph0";
end

    e           = 1.6e-19; 
    a0          = 5.2918e-11; 
    epsilon_0   = 8.85e-12;
    mu_MW       = 1443.45*e*a0; 
    mu_12       = 4.5022*e*a0; 
    hbar        = 6.626e-34 / (2*pi); 
    c0          = physconst('LightSpeed');

    Omega_p     = RAQR_config.Omega_p; 
    N0          = RAQR_config.N0;
    kp          = 2*pi/(RAQR_config.lambda_p); 

    
    [rho_steady, ~]     = getSteadySolution(RAQR_config, RAQR_config.A_LO); 
    alpha_0             = -(kp*N0*(mu_12^2))/(epsilon_0*hbar*Omega_p)*imag(rho_steady(2,1));
    P_probe             = 29.8e-6; 
    probeTransmission   = exp(-2*alpha_0*RAQR_config.d); 
    Iph0                = (RAQR_config.eta*P_probe)/(hbar*(c0*kp))*e*probeTransmission; 
    
    
    if method == "Iph0"
        ret = Iph0;

    elseif method == "gq_PreFactor"
        ret = Iph0*(2*kp*N0*(mu_12^2))/(epsilon_0*hbar*Omega_p); 

    elseif method == "factor2"
        ret = (2*kp*N0*(mu_12^2))/(epsilon_0*hbar*Omega_p); 

    else
        error('Method %s not implemented.', method); 
    end

end

