function fn = get_fn(beta, n)
    N = length(beta);
    fn = zeros(size(beta));

    for idx = 1:N
        if abs(beta(idx)) < 1e-6
            if mod(n, 2) == 0
                fn(idx) = 2/(n+1);
            else
                fn(idx) = 0;
            end
            return;
        end
        
        if n == 0           % f0(t) = 2sin(t)/t. 
            fn(idx) = 2*sinc(beta(idx)/pi);

        elseif n == 2       % f2(t) = 
            fn(idx) = 2*(sinc(beta(idx)/pi) + 2/(beta(idx)^2)*(cos(beta(idx))-sinc(beta(idx)/pi)));

        elseif n == 1       % f1(t) = 2i*(-cos(t)/t+sin(t)/t^2). 
            fn(idx) = 2i*(-beta(idx)*cos(beta(idx))+sin(beta(idx)))/beta(idx)^2;

        elseif n == 3
            % fn_handle = @(x)(x.^n .* exp(1i*beta(idx)*x));
            % fn(idx) = integral(fn_handle, -1, 1);
            t = beta(idx);
            fn(idx) = 2i*(6*cos(t)/t^3-cos(t)/t-6*sin(t)/t^4+3*sin(t)/t^2);

        else
            error('Not implemented.'); 
        end
    end
end
