function hashValue = hashStruct(myStruct, method)
    % hashStruct - Returns hash value of a MATLAB struct
    % method - optional, e.g., 'SHA-256', 'MD5', etc. Default: 'SHA-256'

    if nargin < 2
        method = 'SHA-256';
    end

    % Serialize the struct using JSON (text-based)
    jsonStr = jsonencode(orderfields(myStruct));  % orderfields for consistent field order
    
    % Convert to bytes
    byteData = uint8(jsonStr);

    % Use built-in Java MessageDigest
    md = java.security.MessageDigest.getInstance(method);
    md.update(byteData);
    hash = md.digest();

    % Convert to hex string
    hashValue = dec2hex(typecast(hash, 'uint8'))';
    hashValue = lower(hashValue(:)');  % convert to a single lowercase string
end