clear; close all; clc; 

RAQR_config.d   = 2e-2;                 % 2cm
RAQR_config.N0  = (4.89e10)*(1e6);      % number of atoms per m^3 

RAQR_config.Delta_p = 2*pi*1e3; 
RAQR_config.Delta_c = 2*pi*0e6;         % Coupling laser detuning
RAQR_config.Delta_l = 2*pi*0e3; 

RAQR_config.gamma   = 0;
RAQR_config.gamma_2 = 2*pi*5.2e6; 
RAQR_config.gamma_3 = 2*pi*3.9e3; 
RAQR_config.gamma_4 = 2*pi*1.7e3; 
RAQR_config.gamma_c = 0; 

% RAQR_config.Omega_c     = 2*pi*0.97e6;                % coupling beam 17.0mW  @ 510nm
RAQR_config.Omega_p     = 2*pi*8.08e6;                  % coupling/control beam 17.0mW  @ 510nm, if this is stronger, you will get a better EIT spectrum 
RAQR_config.Omega_c     = 2*pi*2.05e6;                  % probe    beam 29.8uW  @ 852nm


RAQR_config.lambda_c    = 510e-9; 
RAQR_config.lambda_p    = 852e-9; 


%% Simulation of Probe transmission splitting
sim_config.dt       = 1e-9;
sim_config.T        = 300e-6;
sim_config.t_arr    = 0:sim_config.dt:sim_config.T; 
sim_config.Nt       = length(sim_config.t_arr);

RF_strengths = db2mag(-100:0.2:-20);       % dB(V/m)
fDelta_p_arr = (-200:0.04:200).'*(1e6); 

% Case 0: No control light
RAQR_config.Omega_c = 2*pi*10; 
probeSpectra_0 = getProbeSpectrum(RAQR_config, sim_config, fDelta_p_arr, db2mag(-120)); 


% Case 1: with control light 
RAQR_config.Omega_c = 2*pi*2.05e6; 
probeSpectra_1 = getProbeSpectrum(RAQR_config, sim_config, fDelta_p_arr, db2mag(-120)); 

% Case 2: with RF LO 
probeSpectra_2 = getProbeSpectrum(RAQR_config, sim_config, fDelta_p_arr, 3); 



%% Visualization
close all; clc; 
saveFigs = false; 
set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    12);
set(0,'DefaultAxesFontSize',    14);
set(0,'DefaultLineLineWidth',   1.5);
set(0,'defaultfigurecolor',     'w');

fig1 = figure(1); 
plot(fDelta_p_arr/1e6, probeSpectra_0); 
xlabel('Probe detuning (MHz)'); 
ylabel('Probe transmission'); 

fig2 = figure(2); 
plot(fDelta_p_arr/1e6, probeSpectra_1); 
xlabel('Probe detuning (MHz)'); 
ylabel('Probe transmission'); 

fig3 = figure(3); 
plot(fDelta_p_arr/1e6, probeSpectra_2); 
xlabel('Probe detuning (MHz)'); 
ylabel('Probe transmission'); 



%% utils
function probeSpectra = getProbeSpectrum(RAQR_config, sim_config, fDelta_p_arr, RF_strengths)
    
    sim_config.dt       = 1e-9;
    sim_config.T        = 50e-6;
    sim_config.t_arr    = 0:sim_config.dt:sim_config.T; 
    sim_config.Nt       = length(sim_config.t_arr);
    
    Nscan               = length(fDelta_p_arr); 
    probeSpectra        = zeros(Nscan, length(RF_strengths)); 
    
    % E_RF                = 0.001*sin(10e3*2*pi*sim_config.t_arr);   
    Nrf = length(RF_strengths); 

    for idx_rf = 1:Nrf
        E_RF = RF_strengths(idx_rf); 
        i_probeTransmission_arr = zeros(Nscan, 1); 

        for idx_scan = 1:Nscan
            fDelta_p                            = fDelta_p_arr(idx_scan); 
        
            temp_RAQR_config                    = RAQR_config; 
            temp_RAQR_config.Delta_p            = 2*pi*fDelta_p;  
            % [~, probeResponse]              = transientRAQRSimulation(temp_RAQR_config, sim_config, E_RF); 
            % i_probeTransmission_arr(idx_scan) = probeResponse(end); 
            info_struct                         = getAnalyticalSteadyStateWithDoppler(temp_RAQR_config, E_RF, 300); 
            i_probeTransmission_arr(idx_scan)   = info_struct.Tp_ss; 
            % fprintf('Scan probe detuning = %.2f MHz complete, probe transmission = %.2f dB\n', fDelta_p/1e6, probeResponse(end)); 
        end

        probeSpectra(:, idx_rf) = db2pow(i_probeTransmission_arr); 
        fprintf('Scan RF strength %.2f dB(V/m) complete.\n', mag2db(RF_strengths(idx_rf))); 
    end

end


