clear; close all; clc; 

RAQR_config = configureRAQR("Transit"); 

% RAQR_config.Omega_c     = 2*pi*0.97e6;  % coupling beam 17.0mW  @ 510nm
% RAQR_config.Omega_p     = 2*pi*5.7e6;   % probe    beam 29.8uW  @ 852nm
% RAQR_config.Omega_c     = 2*pi*2.05e6; 
% RAQR_config.Omega_p     = 2*pi*8.08e6; 

RAQR_config.lambda_c    = 510e-9; 
RAQR_config.lambda_p    = 852e-9; 


%% Simulation of Autler-Townes splitting
sim_config.dt       = 1e-9;
sim_config.T        = 150e-6;
sim_config.t_arr    = 0:sim_config.dt:sim_config.T; 
sim_config.Nt       = length(sim_config.t_arr);

dDelta = 0.1; 
fDelta_c_arr = (-40:dDelta:40).'*(1e6); 

Nscan = length(fDelta_c_arr); 
probeTransmission_arr = zeros(Nscan, 1); 
probeTransSteady_arr = zeros(Nscan, 1); 

E_RF        = 0.8;  


% E_RF = 0.3*sqrt(2)*ones(size(sim_config.t_arr)); 

% % Compare the traditional simulator v.s. Doppler-aware simulator 
% temp_RAQR_config                = RAQR_config; 
% temp_RAQR_config.Delta_c        = 2*pi*3.6e6;   
% % temp_RAQR_config.Delta_c = 2*pi*1e6; 
% 
% 
% [rho_ss1, Tp_dB1]        = getSteadySolutionWithDoppler(temp_RAQR_config, E_RF, Temperature, 2);
% [rho_ss2, Tp_dB2]        = getSteadySolution(temp_RAQR_config, E_RF);
% 
% rho_ss1 
% rho_ss2


E_RF_arr = 0.1:0.1:4; 
N_RF = length(E_RF_arr); 

EITAT_Spectrum = zeros(Nscan, N_RF); 

method = "Analytical"; 
% method = "withDoppler"; 

for idx_rf = 1:N_RF
    tic; 
    Tp_dB = getEITATSpectrum(RAQR_config, fDelta_c_arr, E_RF_arr(idx_rf), 300, method); 
    seconds = toc; 
    
    EITAT_Spectrum(:, idx_rf) = Tp_dB; 
    fprintf('Scan RF Amp = %.2f Vp/m complete within %.2f s\n', E_RF_arr(idx_rf), seconds); 
end


%% Visualization 

Gamma_EIT = RAQR_config.Omega_p*sqrt(2*(RAQR_config.Omega_p^2+RAQR_config.Omega_c^2)/(2*RAQR_config.Omega_p^2+RAQR_config.gamma_2^2)); 
Gamma_EIT = Gamma_EIT / (2*pi); 
fprintf('EIT LineWidth = %.2f MHz\n', Gamma_EIT/1e6); 

close all; 
set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    12);
set(0,'DefaultAxesFontSize',    14);
set(0,'DefaultLineLineWidth',   1.5);
set(0,'defaultfigurecolor',     'w');
savefigs = false;  


fig1 = figure(1); 
% fig1.Position = [744, 181.8, 1084.2, 768.2]; 
[X, Y] = meshgrid(E_RF_arr, fDelta_c_arr/1e6); 
surf(X, Y, EITAT_Spectrum, 'FaceAlpha', 0.7);
colormap('jet'); colorbar; 
view(0, 90); 
xlabel('RF field strength (Vp/m)'); 
ylabel('Coupling detuning (MHz)'); 
zlabel('Probe transmission Tp (dB)');  
shading interp; 
set(gca, 'xlim', [min(E_RF_arr), max(E_RF_arr)]); 
set(gca, 'ylim', [min(fDelta_c_arr), max(fDelta_c_arr)]/1e6); 
if savefigs
    exportgraphics(fig1, "./results/response/T_EIT-AT_Spectrum.pdf", "ContentType", "vector"); 
    fprintf('Files exported.\n'); 
end

% Compute the energy difference of two dressed Rydberg states |+> and |->. 
% This is quite easy, since we note that the X-pauli matrix has eigenvalues
% (1) and (-1). 
a0      = 5.2918e-11; 
e       = 1.6e-19; 
mu_MW   = 1443.45*e*a0; 
hbar    = 6.626e-34 / (2*pi); 
fPeakSeparation = (mu_MW*E_RF(1))/(hbar*2*pi);
fprintf('EIT peak separation = %.2f MHz\n', fPeakSeparation/1e6); 


% The most sensitive operational mode is given by some LO field value
% [V/m].
% Next, we would like to determine the full spectral shape w.r.t. \Omega_c.
% 

fprintf('Script ended\n'); 