(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     31807,        773]
NotebookOptionsPosition[     30803,        742]
NotebookOutlinePosition[     31159,        758]
CellTagsIndexPosition[     31116,        755]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"H", " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "0", ",", " ", "\[CapitalOmega]p", ",", " ", "0", ",", " ", "0"}], 
       "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"\[CapitalOmega]p", ",", " ", 
        RowBox[{
         RowBox[{"-", "2"}], "\[CapitalDelta]p"}], ",", " ", 
        "\[CapitalOmega]c", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "\[CapitalOmega]c", ",", " ", 
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"(", 
          RowBox[{"\[CapitalDelta]p", "+", "\[CapitalDelta]c"}], ")"}]}], ",",
         " ", "\[CapitalOmega]RF"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "\[CapitalOmega]RF", ",", 
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"(", 
          RowBox[{
          "\[CapitalDelta]p", "+", "\[CapitalDelta]c", "+", 
           "\[CapitalDelta]RF"}], ")"}]}]}], "}"}]}], "}"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalLambda]", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Gamma]2", "*", "\[Rho]22"}], "+", 
       RowBox[{"\[Gamma]4", "*", "\[Rho]44"}]}], ",", " ", 
      RowBox[{"\[Gamma]3", "*", "\[Rho]33"}], ",", " ", "0", ",", " ", "0"}], 
     "}"}], "]"}]}], " ", ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalGamma]", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", " ", "\[Gamma]2", ",", " ", "\[Gamma]3", ",", " ", 
      "\[Gamma]4"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A0", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "I"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"KroneckerProduct", "[", 
        RowBox[{
         RowBox[{"IdentityMatrix", "[", "4", "]"}], ",", " ", "H"}], "]"}], 
       " ", "-", " ", 
       RowBox[{"KroneckerProduct", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", "H", "]"}], ",", " ", 
         RowBox[{"IdentityMatrix", "[", "4", "]"}]}], "]"}]}], "  ", ")"}]}], 
    " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"KroneckerProduct", "[", 
        RowBox[{
         RowBox[{"IdentityMatrix", "[", "4", "]"}], ",", " ", 
         "\[CapitalGamma]"}], "]"}], " ", "+", " ", 
       RowBox[{"KroneckerProduct", "[", 
        RowBox[{"\[CapitalGamma]", ",", " ", 
         RowBox[{"IdentityMatrix", "[", "4", "]"}]}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A0", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", " ", "6"}], "]"}], "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"A0", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", " ", "6"}], "]"}], "]"}], " ", "+", " ", 
     "\[Gamma]2"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A0", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", " ", "16"}], "]"}], "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"A0", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", " ", "16"}], "]"}], "]"}], " ", "+", " ", 
     "\[Gamma]4"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"A0", "[", 
     RowBox[{"[", 
      RowBox[{"6", ",", " ", "11"}], "]"}], "]"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"A0", "[", 
      RowBox[{"[", 
       RowBox[{"6", ",", " ", "11"}], "]"}], "]"}], " ", "+", " ", 
     "\[Gamma]3"}]}], ";"}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RR", " ", "=", " ", 
    RowBox[{
     RowBox[{"RowReduce", "[", "A0", "]"}], "//", "MatrixForm"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RR1", " ", "=", " ", 
    RowBox[{"RR", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", " ", "=", " ", 
    RowBox[{"RR1", "[", 
     RowBox[{"[", 
      RowBox[{
       RowBox[{"1", ";;", "15"}], ",", " ", "16"}], "]"}], "]"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x21sol", " ", "=", " ", 
   RowBox[{"Collect", "[", 
    RowBox[{
     RowBox[{"Together", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"a", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"Total", "[", 
          RowBox[{"a", "[", 
           RowBox[{"[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "6", ",", "11"}], "}"}], "]"}], "]"}], "]"}]}],
         ")"}]}], "]"}], ",", " ", "\[CapitalOmega]RF"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x21sol2", " ", "=", " ", 
   RowBox[{"ComplexExpand", "[", 
    RowBox[{"Simplify", "[", 
     RowBox[{"x21sol", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Gamma]3", "\[Rule]", "0"}], ",", 
        RowBox[{"\[Gamma]4", "\[Rule]", "0"}]}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdyksowwEAx/FRyuMyxSS2bFnmstqGmYNai2n9xablkaJpRRmhtEnJLEaj
ljKyg1mUeZT3tCjltUQp7+c4mJbtoCV5/3//w7fP5cvWNKu0kTQajU0GlQv8
6Wh9UFpBF63DGs+XItEQlL5kM7TQp2O1QSU3bIQBp2odur0Xbji6YduCN7Eb
F7CqwXsLJeXffji3+fQO5UTUByzd10Uw8Fe3UD7ZF+Oh+Z6eAAmTkQkNBWMs
yJz3psP6sI4P9T1GGaRxTikX9txy2LnbUwTTujnF0OW8K4FWh7ASDnFdlI8z
CXXw8DqjEc4R4y2Q16RuhZO/RDvky0YoP1PKuuCZRGyEIoagH+ZePVug6e9o
GBZe/4zAUK7YBTUP/lUoJqz+TNIByVQA5sxfPQjwneh8MM8gjOslPZ8op0OH
mZsKl2ZfmdBn02TBUbGfUlao6Ooj5Xgc3XBtsrUP2uLzzbCWZR6EnpdVSjtr
+VzQEZRaHncu4dtKTJKQdDukTobHPwcZ0LLi48F/3hEBdQ==
  "],ExpressionUUID->"07949995-4da7-4881-809d-1c068c3f8289"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"x21t", " ", "=", " ", 
     RowBox[{"Together", "[", "x21sol2", "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x21sol2D", " ", "=", " ", 
     RowBox[{"Denominator", "[", "x21t", "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x21sol2N", " ", "=", " ", 
     RowBox[{"Numerator", "[", "x21t", "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Collect", "[", 
    RowBox[{"x21sol2N", ",", " ", "\[CapitalOmega]RF"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Collect", "[", 
    RowBox[{"x21sol2D", ",", " ", "\[CapitalOmega]RF"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.9560304836840773`*^9, 3.9560304841831837`*^9}, 
   3.9563799780260706`*^9, {3.9563802063973355`*^9, 3.956380219139598*^9}, {
   3.956380253922536*^9, 3.9563802566916924`*^9}, {3.9563803214168468`*^9, 
   3.9563803268503323`*^9}, {3.9563803728739557`*^9, 
   3.956380393031275*^9}},ExpressionUUID->"4d2c5cf4-28db-4ed3-9eb9-\
cb44520ea38f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "16"}], " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]c", "4"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"64", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalOmega]p"}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]c", "4"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalOmega]p"}], "-", 
  RowBox[{"96", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"128", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{
  "64", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"192", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"128", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]p", "5"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"32", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]RF", " ", 
   "\[CapitalOmega]p"}], "-", 
  RowBox[{"96", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalDelta]RF", " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalDelta]RF", " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{
  "96", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF", " ", 
   "\[CapitalOmega]p"}], "+", 
  RowBox[{"192", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF", " ", 
   "\[CapitalOmega]p"}], "-", 
  RowBox[{"32", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF", " ", 
   "\[CapitalOmega]p"}], "+", 
  RowBox[{"192", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF", " ", 
   "\[CapitalOmega]p"}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", "\[CapitalDelta]RF", " ", 
   "\[CapitalOmega]p"}], "-", 
  RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{
  "32", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", "\[CapitalDelta]c", " ", 
   "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"16", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"64", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"24", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"24", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"16", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{
  "32", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
   "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"16", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"8", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "-", 
  RowBox[{"8", " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
      SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalOmega]p"}], "+", 
     RowBox[{
     "16", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", "\[CapitalDelta]c", 
      " ", "\[CapitalDelta]p", " ", "\[CapitalOmega]p"}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
      "\[CapitalOmega]p"}], "+", 
     RowBox[{"8", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalOmega]p"}], "-", 
     RowBox[{"32", " ", "\[CapitalDelta]c", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalOmega]p"}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalOmega]p"}], "+", 
     RowBox[{
     "8", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", "\[CapitalDelta]c", 
      " ", "\[CapitalDelta]RF", " ", "\[CapitalOmega]p"}], "+", 
     RowBox[{
     "8", " ", "\[ImaginaryI]", " ", "\[Gamma]2", " ", "\[CapitalDelta]p", 
      " ", "\[CapitalDelta]RF", " ", "\[CapitalOmega]p"}], "-", 
     RowBox[{
     "16", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
      "\[CapitalDelta]RF", " ", "\[CapitalOmega]p"}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF", " ", 
      "\[CapitalOmega]p"}], "+", 
     RowBox[{"2", " ", "\[CapitalDelta]c", " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "+", 
     RowBox[{"2", " ", "\[CapitalDelta]p", " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}], "+", 
     RowBox[{"2", " ", "\[CapitalDelta]RF", " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"], " ", "\[CapitalOmega]p"}]}], 
    ")"}], " ", 
   SuperscriptBox["\[CapitalOmega]RF", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Gamma]2", " ", 
      "\[CapitalOmega]p"}], "+", 
     RowBox[{"2", " ", "\[CapitalDelta]p", " ", "\[CapitalOmega]p"}]}], ")"}],
    " ", 
   SuperscriptBox["\[CapitalOmega]RF", "4"]}]}]], "Output",
 CellChangeTimes->{{3.9563802295887213`*^9, 3.9563802573928576`*^9}, 
   3.9563803279910216`*^9, 
   3.9563803955597706`*^9},ExpressionUUID->"35d22559-5302-44d8-b529-\
3052855ff227"],

Cell[BoxData[
 RowBox[{
  RowBox[{"16", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]c", "4"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]p"}], "+", 
  RowBox[{"96", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]c", "4"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"]}], "+", 
  RowBox[{"256", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"]}], "+", 
  RowBox[{"384", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"]}], "+", 
  RowBox[{"256", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "5"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]p", "6"]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"96", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalDelta]RF"}], "+", 
  RowBox[{"96", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"128", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"384", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"384", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"128", " ", 
   SuperscriptBox["\[CapitalDelta]p", "5"], " ", "\[CapitalDelta]RF"}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", "\[CapitalDelta]c", " ", 
   "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox["\[Gamma]2", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"]}], "+", 
  RowBox[{"128", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"]}], "-", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"96", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"96", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"128", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"32", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "4"]}], "+", 
  RowBox[{"8", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalOmega]c", "4"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "4"]}], "+", 
  RowBox[{"8", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "4"]}], "+", 
  RowBox[{"8", " ", "\[CapitalDelta]p", " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "4"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "4"]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]c", "4"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"128", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"192", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"128", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]p", "4"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]c", "3"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"192", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", "\[CapitalDelta]p", " ", 
   "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"192", " ", "\[CapitalDelta]c", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"64", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"16", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"16", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"16", " ", "\[CapitalDelta]p", " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "4"]}], "+", 
  RowBox[{"16", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
   SuperscriptBox["\[CapitalOmega]p", "4"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "4"]}], "+", 
  RowBox[{"8", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]p", "4"]}], "+", 
  RowBox[{"8", " ", "\[CapitalDelta]p", " ", "\[CapitalDelta]RF", " ", 
   SuperscriptBox["\[CapitalOmega]p", "4"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["\[CapitalDelta]RF", "2"], " ", 
   SuperscriptBox["\[CapitalOmega]p", "4"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "8"}], " ", 
      SuperscriptBox["\[Gamma]2", "2"], " ", 
      SuperscriptBox["\[CapitalDelta]c", "2"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[Gamma]2", "2"], " ", "\[CapitalDelta]c", " ", 
      "\[CapitalDelta]p"}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[Gamma]2", "2"], " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"]}], "-", 
     RowBox[{"64", " ", "\[CapitalDelta]c", " ", 
      SuperscriptBox["\[CapitalDelta]p", "3"]}], "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[CapitalDelta]p", "4"]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[Gamma]2", "2"], " ", "\[CapitalDelta]c", " ", 
      "\[CapitalDelta]RF"}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[Gamma]2", "2"], " ", "\[CapitalDelta]p", " ", 
      "\[CapitalDelta]RF"}], "-", 
     RowBox[{"32", " ", "\[CapitalDelta]c", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"], " ", "\[CapitalDelta]RF"}], 
     "-", 
     RowBox[{"32", " ", 
      SuperscriptBox["\[CapitalDelta]p", "3"], " ", "\[CapitalDelta]RF"}], 
     "+", 
     RowBox[{"8", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"]}], "+", 
     RowBox[{"8", " ", "\[CapitalDelta]p", " ", "\[CapitalDelta]RF", " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[CapitalDelta]c", "2"], " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}], "-", 
     RowBox[{"32", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]p", " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"], " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}], "-", 
     RowBox[{"16", " ", "\[CapitalDelta]c", " ", "\[CapitalDelta]RF", " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}], "-", 
     RowBox[{"16", " ", "\[CapitalDelta]p", " ", "\[CapitalDelta]RF", " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[CapitalOmega]c", "2"], " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[CapitalOmega]p", "4"]}]}], ")"}], " ", 
   SuperscriptBox["\[CapitalOmega]RF", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[Gamma]2", "2"], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[CapitalDelta]p", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[CapitalOmega]p", "2"]}]}], ")"}], " ", 
   SuperscriptBox["\[CapitalOmega]RF", "4"]}]}]], "Output",
 CellChangeTimes->{{3.9563802295887213`*^9, 3.9563802573928576`*^9}, 
   3.9563803279910216`*^9, 
   3.9563803955688553`*^9},ExpressionUUID->"d2d076cb-c7f2-4eb6-91d8-\
66922d519cae"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]2", " ", "=", " ", 
    RowBox[{"2", "*", "Pi", "*", 
     RowBox[{"(", 
      RowBox[{"52", "/", "10"}], ")"}], "*", "1000000"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]3", " ", "=", " ", 
    RowBox[{"2", "*", "Pi", "*", 
     RowBox[{"(", 
      RowBox[{"39", "/", "10"}], ")"}], "*", "1000"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]4", " ", "=", " ", 
    RowBox[{"2", "*", "Pi", "*", 
     RowBox[{"(", 
      RowBox[{"17", "/", "10"}], ")"}], "*", "1000"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalOmega]p", " ", "=", " ", 
    RowBox[{"2", "*", "Pi", "*", 
     RowBox[{"(", 
      RowBox[{"57", "/", "10"}], ")"}], "*", "1000000"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalOmega]c", " ", "=", " ", 
    RowBox[{"2", "*", "Pi", "*", "10*^6"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalOmega]RF", " ", "=", " ", 
    RowBox[{"2", "*", "Pi", "*", "10000000"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]p", " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]c", " ", "=", " ", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]RF", " ", "=", " ", "0"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{"A0", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Denom", " ", "=", " ", 
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CharacteristicPolynomial", "[", 
       RowBox[{"A0", ",", " ", "s"}], "]"}], "//", "N"}], ",", " ", 
     RowBox[{"Extension", "\[Rule]", 
      RowBox[{"{", "I", "}"}]}]}], "]"}]}], " ", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Det", "[", 
    RowBox[{
     RowBox[{"0", "*", 
      RowBox[{"IdentityMatrix", "[", "16", "]"}]}], "-", "A0"}], "]"}], 
   "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Num", " ", "=", " ", 
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Minors", "[", 
        RowBox[{
         RowBox[{"s", "*", 
          RowBox[{"IdentityMatrix", "[", "16", "]"}]}], "-", 
         RowBox[{"N", "[", "A0", "]"}]}], "]"}], "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ",", " ", 
      RowBox[{"Extension", "\[Rule]", 
       RowBox[{"{", "I", "}"}]}]}], "]"}]}], "*)"}]}]}], "Input",ExpressionUUI\
D->"38ee0c50-f5cd-432e-9c67-9ba26081765f"],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9563800560626607`*^9, 
  3.956380097000208*^9}},ExpressionUUID->"ae335a78-531b-45b7-9fac-\
61333b945b90"],

Cell[BoxData[
 RowBox[{"Real", "[", 
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", "b"}], "+", "c"}], "]"}]], "Output",
 CellChangeTimes->{{3.9563800653976126`*^9, 
  3.956380072800937*^9}},ExpressionUUID->"a3b9613c-0ca9-4375-8523-\
c2fd923b84b8"]
}, Open  ]]
},
WindowSize->{1904, 989},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (2017\:5e745\:670816\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 5795, 169, 367, "Input", "ExpressionUUID" -> \
"07949995-4da7-4881-809d-1c068c3f8289"],
Cell[CellGroupData[{
Cell[6378, 193, 1141, 27, 273, "Input", "ExpressionUUID" -> \
"4d2c5cf4-28db-4ed3-9eb9-cb44520ea38f"],
Cell[7522, 222, 7827, 151, 73, "Output", "ExpressionUUID" -> \
"35d22559-5302-44d8-b529-3052855ff227"],
Cell[15352, 375, 12340, 266, 111, "Output", "ExpressionUUID" -> \
"d2d076cb-c7f2-4eb6-91d8-66922d519cae"]
}, Open  ]],
Cell[27707, 644, 2653, 80, 422, "Input", "ExpressionUUID" -> \
"38ee0c50-f5cd-432e-9c67-9ba26081765f"],
Cell[CellGroupData[{
Cell[30385, 728, 154, 3, 30, "Input", "ExpressionUUID" -> \
"ae335a78-531b-45b7-9fac-61333b945b90"],
Cell[30542, 733, 245, 6, 30, "Output", "ExpressionUUID" -> \
"a3b9613c-0ca9-4375-8523-c2fd923b84b8"]
}, Open  ]]
}
]
*)

