% ================================================= % 
% 
%  This script is meant for the study atomic response
%  considering the Doppler broadening effect. 
% 
% ================================================= % 

clear; close all; clc; 


RAQR_config = configureRAQR("Transit"); 

% RAQR_config.Omega_c     = 2*pi*0.97e6;                % coupling beam 17.0mW  @ 510nm
RAQR_config.Omega_p     = 2*pi*8.08e6;                  % coupling/control beam 17.0mW  @ 510nm, if this is stronger, you will get a better EIT spectrum 
RAQR_config.Omega_c     = 2*pi*2.05e6;                   % probe    beam 29.8uW  @ 852nm


RAQR_config.lambda_c    = 510e-9; 
RAQR_config.lambda_p    = 852e-9; 

RAQR_config.A_LO        = 0.4;         % LO field amplitude (originally 0.04)

kB  = getPhysicalConstant("Boltzmann"); 
T   = 300; 
fc  = 6.9458e9;   
e   = 1.6e-19; 
hbar= 6.626e-34 / (2*pi); 
n0  = pow2db(kB*T)+30; 
Rpd = 10e6; 
zeta = 0.8; 

%% 
% Temperature = 300;
% E_RF        = 0.8;  
% 
% % E_RF = 0.3*sqrt(2)*ones(size(sim_config.t_arr)); 
% 
% % Compare the traditional simulator v.s. Doppler-aware simulator 
% temp_RAQR_config                = RAQR_config; 
% temp_RAQR_config.Delta_c        = 2*pi*3.7e6;   
% % temp_RAQR_config.Delta_c = 2*pi*1e6; 
% 
% 
% [rho_ss1, Tp_dB1]        = getSteadySolutionWithDoppler(temp_RAQR_config, E_RF, Temperature, 2);
% [rho_ss2, Tp_dB2]        = getSteadySolution(temp_RAQR_config, E_RF);
% 
% rho_ss1(2, 1)
% rho_ss2(2, 1)

% Transient simulation parameters
sim_config.dt           = 1e-9;
sim_config.T            = 60e-6;                     % Quantum simulation time-scale 
sim_config.t_arr        = 0:sim_config.dt:sim_config.T-sim_config.dt; 
sim_config.Nt           = length(sim_config.t_arr);
sim_config.Temperature  = 300; 

Efield_seq = RAQR_config.A_LO*ones(1, sim_config.Nt); 
Efield_seq(sim_config.t_arr > 1e-6 & sim_config.t_arr < 20e-6) = RAQR_config.A_LO+0.005;  

tic; 
atomic_resp = transientQuantumSimulation(RAQR_config, sim_config, Efield_seq); 
toc; 


%% Visualization 

close all; 
set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    12);
set(0,'DefaultAxesFontSize',    14);
set(0,'DefaultLineLineWidth',   1.5);
set(0,'defaultfigurecolor',     'w');


figure(1); 
subplot(2, 1, 1); 

yyaxis left; 
plot(sim_config.t_arr*1e6, Efield_seq); 
ylabel('input E-field (Vp/m)')
yyaxis right; 
plot(sim_config.t_arr*1e6, imag(atomic_resp.rho21_seq)); 
ylabel('Imag \rho_2_1'); 
xlabel('time (us)'); 
grid on; 
title('T=300K'); 


subplot(2, 1, 2); 
yyaxis left; 
plot(sim_config.t_arr*1e6, Efield_seq); 
ylabel('input E-field (Vp/m)')
yyaxis right; 
plot(sim_config.t_arr*1e6, imag(atomic_resp.rho21_mid)); 
ylabel('Imag \rho_2_1'); 
xlabel('time (us)'); 
grid on; 
title('T=0K'); 

fprintf('Script ended\n'); 