# ======================================================= #
#   
#   This script studies the dephasing/decay rates of Rydberg states. 
#   
#   Author:    Jieao Zhu
#   Date:      9 July 2025 
#   Comments:  for quantum depopulation rates \gamma in the 
#              proposed qWMMSE algorithm.   
# 
# ======================================================= #

import numpy as np 
import matplotlib.pyplot as plt 
# NOTE: Uncomment following lines ONLY if you are not using installation via pip
# import sys, os
# rootDir = '/path/to/arc/directory' # e.g. '/Users/Username/Desktop/ARC-Alkali-Rydberg-Calculator'
# sys.path.insert(0,rootDir)
# import sys, os
# sys.path.insert(0,"..")

from arc import *  # Import ARC (Alkali Rydberg Calculator)


if __name__ == '__main__': 
    atom = Caesium()

    # Three Rydberg levels in operation: 
    # 47D5/2
    # 48P3/2
    # 45F7/2

    n1 = 47
    n2 = 48
    n3 = 45

    L1 = 2
    L2 = 1
    L3 = 3

    j1 = 2+1.0/2
    j2 = 1+1.0/2
    j3 = 3+1.0/2
    
    T = 300 
    exceedLevels = 10

    withBBR3 = 1.0/atom.getStateLifetime(n1, L1, j1, temperature=T, includeLevelsUpTo=n1+exceedLevels)
    inBandTransition34 = atom.getTransitionRate(n1, L1, j1, n2, L2, j2, temperature=T)
    inBandTransition43 = atom.getTransitionRate(n2, L2, j2, n1, L1, j1, temperature=T)
    inBandTransition53 = atom.getTransitionRate(n3, L3, j3, n1, L1, j1, temperature=T)
    inBandTransition35 = atom.getTransitionRate(n1, L1, j1, n3, L3, j3, temperature=T)
    gamma3 = withBBR3 - inBandTransition34

    withBBR4 = 1.0/atom.getStateLifetime(n2, L2, j2, temperature=T, includeLevelsUpTo=n2+exceedLevels)
    gamma4 = withBBR4 - inBandTransition43
    
    withBBR5 = 1.0/atom.getStateLifetime(n3, L3, j3, temperature=T, includeLevelsUpTo=n3+exceedLevels)
    gamma5 = withBBR5 - inBandTransition53

    f1 = atom.getTransitionFrequency(n1, L1, j1, n2, L2, j2)
    f2 = atom.getTransitionFrequency(n1, L1, j1, n3, L3, j3)

    print('In-band |3> -> |4> rate = 2 pi * %.3f kHz' % (inBandTransition34/(2*np.pi*1e3)))
    print('In-band |4> -> |3> rate = 2 pi * %.3f kHz' % (inBandTransition43/(2*np.pi*1e3)))
    print('In-band |5> -> |3> rate = 2 pi * %.3f kHz' % (inBandTransition53/(2*np.pi*1e3)))
    print('In-band |3> -> |5> rate = 2 pi * %.3f kHz' % (inBandTransition35/(2*np.pi*1e3)))

    print('|3> state decay rate: 2 pi * %.3f kHz' % (gamma3/(2*np.pi*1e3)))
    print('|4> state decay rate: 2 pi * %.3f kHz' % (gamma4/(2*np.pi*1e3)))
    print('|5> state decay rate: 2 pi * %.3f kHz' % (gamma5/(2*np.pi*1e3)))

    print('f1 = %.3f GHz' % (f1/1e9))
    print('f2 = %.3f GHz' % (f2/1e9))

    print('Rydberg calculation complete')






    