% ======================================================= % 
% 
%  This file studies why the main pole appear at ~200kHz.   
%  
%  
% ======================================================= % 

clear; clc; close all; 


RAQR_config = configureRAQR(); 

scaleFactor = 1; 

Nc = 100; Np = 101; 
[Omega_cMat, Omega_pMat] = meshgrid(linspace(0, 2*pi*4e6, Nc), linspace(0, 2*pi*8.08e6, Np)); 


scanRange   = (0.01:0.01:1).';
Nscan       = length(scanRange); 
ps          = zeros(Np, Nc); 


hbar    = 6.626e-34 / (2*pi); 
a0      = 5.2918e-11; 
e       = 1.6e-19; 
mu_MW   = 1443.45*e*a0; 
% mu_12   = 4.5022*e*a0; 

for cidx = 1:Nc
    for pidx = 1:Np
        % Extract RARQ configurations
        Delta_p = RAQR_config.Delta_p; 
        Delta_c = RAQR_config.Delta_c; 
        Delta_l = RAQR_config.Delta_l; 
            
        
        gamma   = RAQR_config.gamma; 
        gamma_2 = RAQR_config.gamma_2*1; 
        gamma_3 = RAQR_config.gamma_3*scaleFactor; 
        gamma_4 = RAQR_config.gamma_4*scaleFactor; 
        gamma_c = RAQR_config.gamma_c; 
        
        % Omega_c     = RAQR_config.Omega_c; 
        % Omega_p     = RAQR_config.Omega_p;  
        Omega_c = Omega_cMat(pidx, cidx); 
        Omega_p = Omega_pMat(pidx, cidx); 

        Omega_RF    = mu_MW*(RAQR_config.A_LO)/hbar;       
        
        % Quantum state definition 
        %  |1> 6S1/2    |2> 6P3/2   |3> 47D5/2          |4> 48P3/2 
        Delta_p = -Delta_p; Delta_c = -Delta_c; Delta_l = -Delta_l; 
        
        H = [0,         Omega_p/2,  0,                  0;                  ...
            Omega_p/2,  Delta_p,    Omega_c/2,          0;                  ...
            0,          Omega_c/2,  Delta_p+Delta_c,    Omega_RF/2;         ...
            0,          0,          Omega_RF/2,         Delta_p+Delta_c+Delta_l]; 
            
        Gamma = diag([gamma, gamma+gamma_2, gamma+gamma_3+gamma_c, gamma+gamma_4]); 
            
            
        % Re-order the elements of ρ to construct a vector differential equation 
        % dx/dt = Ax + b
        
        A           = -1i*(kron(eye(4), H) - kron(H.', eye(4))) - (1/2)*(kron(eye(4), Gamma) + kron(Gamma, eye(4))); 
        A(1, 6)     = A(1, 6) + gamma_2; 
        A(1, 16)    = A(1, 16) + gamma_4; 
        A(6, 11)    = A(6, 11) + gamma_3; 
        
        % Get steady-state solution 
        u4 = zeros(1, 16); u4([1, 6, 11, 16]) = 1; 
        
        Aext        = [A; 1e4*u4];  
        [U, S, V]   = svd(Aext); 
        s           = diag(S); 
        tmp         = (U'*[zeros(16, 1); 1e4]); 
        xvec_steady = V*inv(diag(s))*tmp(1:16); 
        % 
        % fprintf('Steady-state rho2_1='); 
        % disp(xvec_steady(2)); 
        
        % Perform symmetrization on xvec_steady
        rho_steady = reshape(xvec_steady, [4,4]); 
        rho_steady = (rho_steady+rho_steady')/2; 
        xvec_steady = rho_steady(:); 
        
        
        Qtmp        = eye(16); 
        Qtmp(:,1)   = (u4.')/norm(u4); 
        [Q, R]      = qr(Qtmp); 
        Q(:,1)      = -Q(:, 1); 
        
        % (y = Q'*x) is the variable substituion 
        A_new = Q'*A*Q; 
        assert(norm(A_new(1, :)) < 1e-6); % The first row of A is all-zero. 
        
        % Eqn: dy(2:n)/dt = y(1)*w + A_tilde*y(2:n), where y1(t) is always
        % constant = (1/2).
        w       = A_new(2:end, 1); 
        A_tilde = A_new(2:end, 2:end); 
        
        % [Vtilde, Dtilde] = eig(A_tilde); 
        
        % Let y(2:16) = z
        z_steady = -(A_tilde)\((1/2)*w); 
        
        % Recover x_steady from z_steady 
        y_steady = [(1/2); z_steady]; 
        x_steady = Q*y_steady; 
        
        
        % Evaluate the characteristic polynomial of A_tilde 
        pA1 = poly(A_tilde); 
        
        % syms s; 
        % tmp = s*eye(15)-A_tilde; 
        % pA2 = sym2poly(det(tmp));  
        
        
        % Study the system characteristic polynomial 
        
        % chara. poly. (denominator)
        pA16    = poly(A); 
        rts     = roots(pA16);
        
        % for idx = 1:16
        %     fprintf('%.3f kHz, %.3f kHz\n', -real(rts(idx))/(2*pi*1e3), -imag(rts(idx))/(2*pi*1e3) ); 
        % end
        
        % We may need another algorithm (in the 16-element domain) to evaluate the T34 and T43. 
        [E34, E43] = getActionMatrices(); 
        
        ps(pidx, cidx)  = -real(rts(14))/(2*pi*1e3); 
    end
end

%% Visualizations 
close all; 
set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',   12);
set(0,'DefaultAxesFontSize',   14);
set(0,'DefaultLineLineWidth',  1.5);
set(0,'defaultfigurecolor','w');

surf(Omega_cMat/(2*pi*1e6), Omega_pMat/(2*pi*1e6), ps);  
shading interp; 
xlabel('\Omega_c/2\pi (MHz)');
ylabel('\Omega_p/2\pi (MHz)'); 
zlabel('Main pole (kHz)'); 

view(0, 90); colorbar; 

