% In this file, we aim to obtain the steady-solution of the EIT system 
clear; clc; close all; 


syms Omega_p Omega_c Delta_p Delta_c Omega_RF Omega_RFc Delta_RF; 

H = [0,         Omega_p/2,  0,                      0;                  ...
    Omega_p/2,  -Delta_p,    Omega_c/2,             0;                  ...
    0,          Omega_c/2,  -Delta_p-Delta_c,       Omega_RF/2;         ...
    0,          0,          Omega_RFc/2,       -Delta_p-Delta_c-Delta_RF]; 

syms gamma_2 gamma_3 gamma_4; 
syms rho [4, 4];

Gamma   = diag([0, gamma_2, gamma_3, gamma_4]); 
Lambda  = diag([gamma_2*rho2_2+gamma_4*rho4_4, gamma_3*rho3_3, 0, 0]); 
tmp     = simplify(-1i*(H*rho-rho*H) - (1/2)*(Gamma*rho+rho*Gamma)+Lambda); 


% Construct steady-state matrix 
if false 
disp(tmp(2,1)); 
disp(tmp(3,1)); 
disp(tmp(4,1)); 

disp(tmp(3,2)); 
disp(tmp(4,2)); 
disp(tmp(4,3)); 

fprintf('===============\n'); 
disp(tmp(1,1)); 
disp(tmp(2,2)); 
disp(tmp(3,3)); 
disp(tmp(4,4)); 
end

% Set-up linear equations for the **steady-state** solution? 
% Express this thing in terms of matrix A. 

A0 = (-1i)*(kron(eye(4), H)-kron(H.', eye(4)))- (1/2)*(kron(Gamma, eye(4)) + kron(eye(4), Gamma)); 
A0(1, 6)    = A0(1, 6) + gamma_2; 
A0(1, 16)   = A0(1, 16) + gamma_4; 
A0(6, 11)   = A0(6, 11) + gamma_3; 

% Perform analysis on (sI-A)^{-1}. 
syms s; 
charEqn = det(s*eye(16)-A0); 
% respFunction = inv(s*eye(16)-A0); 



