function [v, iter_list] = GS_RIS_mod(g, S, A, ratio_min, ratio_max, bitflag)
    f0 = rand(size(A, 2), 1)*2*pi;
    g0 = g.*exp(1j*f0);
    v0_prime = (A*A')\A*g0;
    v0_prime = exp(1j*angle(v0_prime));
    v_hat = v0_prime/norm(v0_prime);
    iter_list = zeros(S, 1);
    for iter = 1:S
        gs = A'*v_hat;
        fs = angle(gs);
        gs_amp = abs(gs);
        max_val = max(gs_amp);
        for loop = 1:length(gs)
            if ~g(loop) && gs_amp(loop) > max_val*ratio_min
                gs_amp(loop) = max_val*ratio_min;
            end
            if g(loop) && gs_amp(loop) < max_val*ratio_max
                gs_amp(loop) = max_val*ratio_max;
            end
        end
        gs_prime = gs_amp.*exp(1j*fs);
        vs_prime = (A*A')\A*gs_prime;
        vs_prime = exp(1j*angle(vs_prime));
        if string(bitflag) ~= "ideal"
            vs_prime = RIS_quant(vs_prime, bitflag);
        end
        v_hat = vs_prime/norm(vs_prime);
        iter_list(iter) = sum(abs(gs - A'*v_hat));
    end
    v = v_hat/norm(v_hat);
    v = conj(v);
end