function v = GS_ideal_window(g, S, A, ratio_min, ratio_max)
    f0 = rand(size(A, 2), 1)*2*pi;
    g0 = g.*exp(1j*f0);
    v0_prime = (A*A')\A*g0;
    v_hat = v0_prime/norm(v0_prime);
    for iter = 1:S
        gs = A'*v_hat;
        fs = angle(gs);
        gs_amp = abs(gs);
        max_val = max(gs_amp);
        for loop = 1:length(gs)
            if ~g(loop) && gs_amp(loop) > max_val*ratio_min
                gs_amp(loop) = max_val*ratio_min;
            end
            if g(loop) && gs_amp(loop) < max_val*ratio_max
                gs_amp(loop) = max_val*ratio_max;
            end
        end
        gs_prime = gs_amp.*exp(1j*fs);
        vs_prime = (A*A')\A*gs_prime;
        v_hat = vs_prime/norm(vs_prime);
    end
    v = v_hat/norm(v_hat);
    v = conj(v);
end