function [codebook, G, H] = Ohamming_codebook(Nt1, Nt2, Nr1, Nr2, overrate1, overrate2, A1, A2, mode, bitflag)
    k = round(log2(max(Nt1*Nt2, Nr1*Nr2)));
    for loop = 6:100
        if 2^loop - loop - 1 >= k
            m = loop;
            break;
        end
    end
    k1 = round(log2(Nr1));
    k2 = round(log2(Nr2));
    for loop = 3:100
        if 2^loop - loop - 1 >= k1
            m1 = loop;
            break;
        end
    end
    for loop = 3:100
        if 2^loop - loop - 1 >= k2
            m2 = loop;
            break;
        end
    end
    if mode == "BS"
        N1 = Nt1;
        N2 = Nt2;
    else
        N1 = Nr1;
        N2 = Nr2;
    end
    n = k + m1 + m2;
    k = log2(round(N1*N2));
    codebook = zeros(N1*N2, 2, n);
    [G, H] = generator_check_new(n - k, k, N1, N2, mode, m1, m2);
    u = u_generate(k);

    index1 = mod(u*G, 2);
    index2 = mod(index1 + 1, 2);
    
%     % display pattern
%     index1 = reshape(index1, [N2, N1, n]);
%     figure;
%     for loop = 1:n
%         subplot(4, 4, loop);
%         imagesc(index1(:, :, loop));
%     end

    for loop = 1:n
        if mode == "BS"
            g1 = g_generate(N1, N2, overrate1, overrate2, find(index1(:, loop)' == 1));
            g2 = g_generate(N1, N2, overrate1, overrate2, find(index2(:, loop)' == 1));
            v1 = GS_ideal_window(g1, 100, A1, 0.3, 0.7);
            v2 = GS_ideal_window(g2, 100, A1, 0.3, 0.7);
            codebook(:, 1, loop) = v1;
            codebook(:, 2, loop) = v2;
        else
            temp_idx1 = reshape(index1(:, loop), [N2, N1]);
            temp_idx2 = mod(temp_idx1 + 1, 2);
            if max(sum(temp_idx1, 1)) == N2
                omni = GS_RIS_mod(ones(N2*overrate2, 1), 100, A2, 0.2, 0.8, bitflag);
                temp_idx1 = temp_idx1(1, :);
                temp_idx2 = temp_idx2(1, :);
                g1 = g_generate(N1, 1, overrate1, 1, find(temp_idx1 == 1));
                g2 = g_generate(N1, 1, overrate1, 1, find(temp_idx2 == 1));
                v11 = GS_RIS_mod(g1, 100, A1, 0.3, 0.7, bitflag);
                v22 = GS_RIS_mod(g2, 100, A1, 0.3, 0.7, bitflag);
                v1 = kron(v11, omni);
                v2 = kron(v22, omni);
                codebook(:, 1, loop) = v1;
                codebook(:, 2, loop) = v2;
            else
                omni = GS_RIS_mod(ones(N1*overrate1, 1), 100, A1, 0.2, 0.8, bitflag);
                temp_idx1 = temp_idx1(:, 1)';
                temp_idx2 = temp_idx2(:, 1)';
                g1 = g_generate(N2, 1, overrate2, 1, find(temp_idx1 == 1));
                g2 = g_generate(N2, 1, overrate2, 1, find(temp_idx2 == 1));
                v11 = GS_RIS_mod(g1, 100, A2, 0.3, 0.7, bitflag);
                v22 = GS_RIS_mod(g2, 100, A2, 0.3, 0.7, bitflag);
                v1 = kron(omni, v11);
                v2 = kron(omni, v22);
                codebook(:, 1, loop) = v1;
                codebook(:, 2, loop) = v2;
            end
%             v1 = GS_RIS_mod(g1, 400, A, 0.3, 0.7, bitflag);
%             v2 = GS_RIS_mod(g2, 400, A, 0.3, 0.7, bitflag);
%             codebook(:, 1, loop) = v1;
%             codebook(:, 2, loop) = v2;
        end
    end
end