function [codebook] = binary_hierarchical_codebook(N1, N2, overrate1, overrate2, A1, A2, mode, bitflag)
    codebook = zeros(N1*N2, 2, round(log2(N1*N2)));
    for loop = 1:round(log2(N1*N2))
        sector = 2^loop;
        start_idx = 1:(N1*N2)/sector:N1*N2;
        index1 = [];
        index2 = [];
        for loop1 = 1:sector/2
            index1 = [index1, start_idx(loop1*2 - 1):1:start_idx(loop1*2 - 1) + N1*N2/sector - 1];
            index2 = [index2, start_idx(loop1*2):1:start_idx(loop1*2) + N1*N2/sector - 1];
        end
        if mode == "BS"
            g1 = g_generate(N1, N2, overrate1, overrate2, index1);
            g2 = g_generate(N1, N2, overrate1, overrate2, index2);
            v1 = GS_ideal_window(g1, 100, A1, 0.3, 0.7);
            v2 = GS_ideal_window(g2, 100, A1, 0.3, 0.7);
            codebook(:, 1, loop) = v1;
            codebook(:, 2, loop) = v2;
        else
            temp_idx1 = zeros(N1*N2, 1);
            temp_idx2 = zeros(N1*N2, 1);
            temp_idx1(index1) = 1;
            temp_idx2(index2) = 1;
            temp_idx1 = reshape(temp_idx1, [N2, N1]);
            temp_idx2 = reshape(temp_idx2, [N2, N1]);
            if max(sum(temp_idx1, 1)) == N2 % phi2 omni
                omni = GS_RIS_mod(ones(N2*overrate2, 1), 100, A2, 0.2, 0.8, bitflag);
                temp_idx1 = temp_idx1(1, :);
                temp_idx2 = temp_idx2(1, :);
                g1 = g_generate(N1, 1, overrate1, 1, find(temp_idx1 == 1));
                g2 = g_generate(N1, 1, overrate1, 1, find(temp_idx2 == 1));
                v11 = GS_RIS_mod(g1, 100, A1, 0.3, 0.7, bitflag);
                v22 = GS_RIS_mod(g2, 100, A1, 0.3, 0.7, bitflag);
                v1 = kron(v11, omni);
                v2 = kron(v22, omni);
                codebook(:, 1, loop) = v1;
                codebook(:, 2, loop) = v2;
            else
                omni = GS_RIS_mod(ones(N1*overrate1, 1), 100, A1, 0.2, 0.8, bitflag);
                temp_idx1 = temp_idx1(:, 1)';
                temp_idx2 = temp_idx2(:, 1)';
                g1 = g_generate(N2, 1, overrate2, 1, find(temp_idx1 == 1));
                g2 = g_generate(N2, 1, overrate2, 1, find(temp_idx2 == 1));
                v11 = GS_RIS_mod(g1, 100, A2, 0.3, 0.7, bitflag);
                v22 = GS_RIS_mod(g2, 100, A2, 0.3, 0.7, bitflag);
                v1 = kron(omni, v11);
                v2 = kron(omni, v22);
                codebook(:, 1, loop) = v1;
                codebook(:, 2, loop) = v2;
            end

%             g1 = g_generate(N1, N2, overrate1, overrate2, index1);
%             g2 = g_generate(N1, N2, overrate1, overrate2, index2);
%             v1 = GS_RIS_mod(g1, 200, A1, 0.3, 0.7, bitflag);
%             v2 = GS_RIS_mod(g2, 200, A1, 0.3, 0.7, bitflag);
% %             v1 = GS_RIS_iter(g1, 200, A, N1, N2, 200);
% %             v2 = GS_RIS_iter(g2, 200, A, N1, N2, 200);
%             codebook(:, 1, loop) = v1;
%             codebook(:, 2, loop) = v2;
        end
    end
end