function [H, v1, v2, theta, phi0, phi1, idx_Nt, idx_Nr1, idx_Nr2] = channel_BR(Nt, Nr1, Nr2, L)
%     theta = rand(1, L) * 2*pi/3 - pi/3;
%     phi0 = rand(1, L) * 2*pi/3 - pi/3;
%     phi1 = rand(1, L) * 2*pi/3 - pi/3;
    theta_list = -1+1/Nt:2/Nt:1-1/Nt;
    phi_list0 = -1+1/Nr1:2/Nr1:1-1/Nr1;
    phi_list1 = -1+1/Nr2:2/Nr2:1-1/Nr2;
    idx_Nt = ceil(rand(1, L)*length(theta_list));
    idx_Nr1 = ceil(rand(1, L)*length(phi_list0));
    idx_Nr2 = ceil(rand(1, L)*length(phi_list1));
    theta = asin(theta_list(idx_Nt));
    phi0 = asin(phi_list0(idx_Nr1));
    phi1 = asin(phi_list1(idx_Nr2));
%     phi0 = 0;
%     phi1 = 0;
    H = zeros(Nr1*Nr2, Nt);
    G = (randn(1, L) + 1j*randn(1, L))/sqrt(2);
    for lidx = 1:L
        v1 = array_response(Nt, 1, theta(lidx), 0);
        v2 = array_response(Nr1, Nr2, phi0(lidx), phi1(lidx));
        H = H + G(lidx)*v2*v1.';
    end
end