function [H, phi0, phi1, idx_Nr1, idx_Nr2] = channel_RU(Nt1, Nt2, L)
%     phi0 = rand(1, L) * 2*pi/3 - pi/3;
%     phi1 = rand(1, L) * 2*pi/3 - pi/3;
    phi_list0 = 0:2/Nt1:2-2/Nt1;
    phi_list1 = 0:2/Nt2:2-2/Nt2;
    idx_Nr1 = ceil(rand(1, L)*length(phi_list0));
    idx_Nr2 = ceil(rand(1, L)*length(phi_list1));
    phi0 = asin(phi_list0(idx_Nr1));
    phi1 = asin(phi_list1(idx_Nr2));
%     phi0 = 0;
%     phi1 = 0;
    H = zeros(1, Nt1*Nt2);
    G = (randn(1, L) + 1j * randn(1, L))/sqrt(2);
    for lidx = 1:L
        v = array_response(Nt1, Nt2, phi0(lidx), phi1(lidx));
        H = H + G(lidx)*v.';
    end
end