function codebook = exhaustive_codebook(N1, N2)
    theta_list1 = -1 + 1/N1:2/N1:1 - 1/N1;
    theta_list2 = -1 + 1/N2:2/N2:1 - 1/N2;
    codebook = zeros(N1*N2, N1*N2);
    for loop1 = 1:length(theta_list1)
        for loop2 = 1:length(theta_list2)
            codebook(:, (loop1 - 1)*length(theta_list2) + loop2) = array_response(N1, N2, asin(theta_list1(loop1)), asin(theta_list2(loop2)));
        end
    end
end