function [at_BS, at_RIS] = exhaustive_train(H_br, H_ru, SNR_dB, e_codebook_BS, e_codebook_RIS, overhead)
    powermax = 0;
    for loop = 1:min(overhead, size(e_codebook_BS, 2)*size(e_codebook_RIS, 2))
        powerbuffer = abs(H_ru*diag(e_codebook_RIS(:, mod(loop - 1, size(e_codebook_RIS, 2)) + 1))*H_br*e_codebook_BS(:, ceil(loop/size(e_codebook_RIS, 2))));
        powerbuffer = abs(awgn(powerbuffer, SNR_dB));
        if powerbuffer > powermax
            powermax = powerbuffer;
            at_BS = e_codebook_BS(:, ceil(loop/size(e_codebook_RIS, 2)));
            at_RIS = e_codebook_RIS(:, mod(loop - 1, size(e_codebook_RIS, 2)) + 1);
        end
    end
end