function w = GenerateComBeam(w_c, tau, f)
    M = numel(f);
    N = numel(w_c);
    K = numel(tau);
    P = N/K;
    
    w_c = reshape(w_c, [N,1]);
    tau = reshape(tau, [K,1]);
    f = reshape(f, [1,M]);
    
    tau = tau - min(tau);
    p = exp(-1j * 2 * pi * tau * f);
    p = reshape(p, [K, M]);
    w = w_c.* kron(p, ones(P,1));

end

