clear all;  clc;
Nt = 256; % number of antennas
K = 8;      % number of sub-arrays 
fc = 100e9; % carrier frequency
c = 3e8;
lambda_c = c/fc;
d = lambda_c / 2;
B = 0.05*fc; % bandwidth
M = 128; % subcarrier number 
f = zeros(M,1); % subcarrier frequency
for m =1:M
   f(m) = fc+B/(M)*(m-1-(M-1)/2);
end

Pt = 4;
SNR_dB= 5;
SNR = 10.^(SNR_dB/10.);

Nu_list = [1,2,3,4,5,6,7,8]; % list of user numbers
R_min = 1;
R_max = 30;
theta_min = -pi/3;
theta_max = pi/3;
    
% Power budget of each RF components
PT = 30/1e3;  % Transmission power
PBB = 200/1e3;  % baseband power 
PRF = 250/1e3;  % RF chain power
PPS = 30/1e3;   % phase shifter
PTTD = 100/1e3; % TTD


N_iter = 100;
EE0=zeros(1,length(Nu_list));
EE1=zeros(1,length(Nu_list));
EE2=zeros(1,length(Nu_list));
EE3=zeros(1,length(Nu_list));
EE4=zeros(1,length(Nu_list));

t0 = clock;
parfor idx = 1:length(Nu_list)
      Nu = Nu_list(idx);
      P_HP = PT + PBB + PRF*Nu + PPS*Nt*Nu; 
      P_FP = PT + PBB + PTTD*Nt*Nu; 
      P_DPP = PT + PBB + PRF*Nu + PPS*Nt*Nu + PTTD*K*Nu;  
      for iter = 1:N_iter
            if mod(iter,10) == 0
                fprintf('Iteration:[%d/%d] | Nu:[%d/%d] | run %.4f s\n', iter, N_iter, Nu, Nu_list(length(Nu_list)), etime(clock, t0)); 
            end

           [H, Hc, x, y] = near_Multipath_channel(Nt,Nu, d,fc, B, M, R_min, R_max, theta_min, theta_max);


          %% optimal 
            W0 = zeros(Nt, Nu, M);
            for m = 1:M
                Hm = H(:,:,m);
                Wm0 = pinv(Hm.'); 
                Wm0 = sqrt(Pt) * Wm0 / norm(Wm0(:));
                W0(:, :, m) = Wm0;
                EE0(1, idx) = EE0(1, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wm0*Wm0')*conj(Hm))*SNR* Nt)))/P_FP/M/N_iter;
            end
            
          %% wideband bessel
            Wa2 = zeros(Nt, Nu, M);
            for i_u = 1:Nu
                [wc2, tau2] = wideband_bessel(Nt, K, x(i_u), y(i_u), fc, d);
                w2 = GenerateComBeam(wc2, tau2, f);
                for m = 1:M
                    Wa2(:, i_u, m) = w2(:, m); 
                end
            end
            for m=1:M
                 Hm = H(:,:,m);
                 Wd2 = pinv(Hm.'* Wa2(:, :, m));
                 Wh2 = Wa2(:,:,m) * Wd2;
                 Wh2 = sqrt(Pt) * Wh2 / norm(Wh2(:)); 
                 EE2(1, idx) = EE2(1, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh2*Wh2')*conj(Hm))*SNR* Nt)))/P_DPP/M/N_iter;
            end

  
            %% wideband beamforming
            Wa3 = zeros(Nt, Nu, M);
            for i_u = 1:Nu
                [wc3, tau3] = wideband_beamform(Nt, K, x(i_u), y(i_u), fc);
                Wa3(:, i_u, :) = GenerateComBeam(wc3, tau3, f);
            end
            for m=1:M
                 Hm = H(:,:,m);
                 Wd3 = pinv(Hm.'* Wa3(:, :, m));
                 Wh3 = Wa3(:,:,m) * Wd3;
                 Wh3 = sqrt(Pt) * Wh3 / norm(Wh3(:)); 
                 EE3(1, idx) = EE3(1, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh3*Wh3')*conj(Hm))*SNR* Nt)))/P_DPP/M/N_iter;
            end


            %% ALTMin
            Wa4 = AltMin(W0, Nt, Nu, Nu);
            Wa4 = sqrt(Nu)*Wa4/norm(Wa4(:));
            for m=1:M
                 Hm = H(:,:,m);
                 Wd4 = pinv(Hm.'* Wa4);
                 Wh4 = Wa4 * Wd4;
                 Wh4 = sqrt(Pt) * Wh4 / norm(Wh4(:)); 
                 EE4(1, idx) = EE4(1, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh4*Wh4')*conj(Hm))*SNR* Nt)))/P_HP/M/N_iter;
             end

            %% narrow focus
            Wa1 = zeros(Nt, Nu);
            for i_u = 1:Nu
                Wa1(:, i_u) = narrow_focus( Hc(:, i_u).', Nt);
            end
            for m=1:M
                 Hm = H(:,:,m);
                 Wd1 = pinv(Hm.'* Wa1);
                 Wh1 = Wa1 * Wd1;
                 Wh1 = sqrt(Pt) * Wh1 / norm(Wh1(:)); 
                 EE1(1, idx) = EE1(1, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh1*Wh1')*conj(Hm))*SNR* Nt)))/P_HP/M/N_iter;
            end
     end
end
%% visualization



figure; hold on; grid on;box on;
p0 = plot(Nu_list, EE0, '--','Linewidth',1.2, 'color',[0,114,189]/256);
p2 = plot(Nu_list, EE2, '-o','Linewidth',1.2, 'color',[217,83,25]/256);
p3 = plot(Nu_list, EE3, '-s','Linewidth',1.2, 'color',[237,177,32]/256);
p4 = plot(Nu_list, EE4, '-d','Linewidth',1.2, 'color',[126,47,142]/256);
p1 = plot(Nu_list, EE1, '-^','Linewidth',1.2, 'color',[119,172,48]/256);
xlim([min(Nu_list), max(Nu_list)])
xticks(Nu_list);

l3 = legend([p0,p2,p3,p4,p1], {'Optimal beamforming','Proposed PDF',  ...
    'TTD-DPP','PE-AltMin', 'Beamfocusing'});
l1 = xlabel('The number of users');
l2 = ylabel('Energy efficiency [bit/s/Hz/W]');
% xlim([min(Nt_list),256])
set(l1, 'Fontsize', 12, 'FontName', 'Times','Interpreter','latex');
set(l2, 'Fontsize', 12, 'FontName', 'Times','Interpreter','latex');
set(l3, 'Fontsize', 10, 'FontName', 'Times','Interpreter','latex');

