function [H, Hc, x, y] = near_Multipath_channel(Nt, Nu, d, fc, B, M, R_min, R_max, theta_min, theta_max)
% Input:
% Nt-number of BS antennas
% Nu-number of single-antenna users
% d-antenna spacing
% fc-central carrier
% B-bandwidth
% M-number of subcarriers
% R_min-minimal user-to-BS distance
% R_max-maximal user-to-BS distance
% theta_min-minimal user-to-BS angle
% theta_max-maximal user-to-BS angle


H = zeros(Nt, Nu, M);
nn = (0:1:Nt-1)';


% randomly generate user locations 
r0 = R_min + rand(1, Nu) * (R_max - R_min);
theta0 = theta_min +rand(1,Nu) * (theta_max - theta_min);
x = r0.*cos(theta0); 
y = r0.*sin(theta0) + (Nt-1)*d/2;
L = sqrt(x.^2 + (y - nn.*d).^2);

% path losses
g0 = randn(1, Nu) + 1j*randn(1, Nu);
g0 = sqrt(Nu)*g0/norm(g0);


c = 3e8;
for m = 1:M+1
   if m == M+1
        fm = fc;
        Hc = g0.*exp(-1j*2*pi*fm.*L/c)/sqrt(Nt);
   else
        fm=fc+B/(M)*(m-1-(M-1)/2);
        H(:,:,m) = g0.*exp(-1j*2*pi*fm.*L/c)/sqrt(Nt);
   end 
    

end

end

