clear all;  clc;
Nt = 256;   % Number of antennas
Nu = 4;     % NUmber of users
fc = 100e9; % carrier frequency
c = 3e8;
lambda_c = c/fc;
d = lambda_c / 2;  % antenna spacing
B = 5e9; % bandwidth
M = 128; % number of subcarriers
f = zeros(M,1); % subcarrier frequency
for m =1:M
   f(m) = fc+B/(M)*(m-1-(M-1)/2);
end

Pt = 4;
SNR_dB= -10;
SNR = 10.^(SNR_dB/10.);

K = 8; % number of TTDs
 
Nt_list = 8*(1:2:32);  % the list of number of transmit antennas
Nt_len = length(Nt_list);

N_iter = 200;
Rate0=zeros(N_iter,length(Nt_list));
Rate1=zeros(N_iter,length(Nt_list));
Rate2=zeros(N_iter,length(Nt_list));
Rate3=zeros(N_iter,length(Nt_list));
Rate4=zeros(N_iter,length(Nt_list));

% distance and direction region
R_min = 1;
R_max = 30;
theta_min = -pi/3;
theta_max = pi/3;
t0 = clock;
parfor idx = 1:Nt_len
    for iter = 1:N_iter
       if mod(iter,50) == 0
            fprintf('iteration:[%d/%d] | Nt:[%d/%d] | run %.4f s\n', iter, N_iter, Nt_list(idx), Nt_list(length(Nt_list)), etime(clock, t0)); 
       end
       Nt = Nt_list(idx);



       [H, Hc, x, y] = near_Multipath_channel(Nt,Nu, d,fc, B, M, R_min, R_max, theta_min, theta_max);
      %% optimal 
        W0 = zeros(Nt, Nu, M);
        for m = 1:M
            Hm = H(:,:,m);
            Wm0 = pinv(Hm.'); 
            Wm0 = sqrt(Pt) * Wm0 / norm(Wm0(:));
            W0(:, :, m) = Wm0;
            Rate0(iter, idx) = Rate0(iter, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wm0*Wm0')*conj(Hm))*SNR* Nt)))/M;
        end




    %% wideband bessel
    Wa2 = zeros(Nt, Nu, M);
    for i_u = 1:Nu
        [wc2, tau2] = wideband_bessel(Nt, K, x(i_u), y(i_u), fc, d);
        w2 = GenerateComBeam(wc2, tau2, f);
        for m = 1:M
            Wa2(:, i_u, m) = w2(:, m); 
        end
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd2 = pinv(Hm.'* Wa2(:, :, m));
         Wh2 = Wa2(:,:,m) * Wd2;
         Wh2 = sqrt(Pt) * Wh2 / norm(Wh2(:)); 
         Rate2(iter, idx) = Rate2(iter, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh2*Wh2')*conj(Hm))*SNR* Nt)))/M;
     end

    %% wideband beamforming
    Wa3 = zeros(Nt, Nu, M);
    for i_u = 1:Nu
        [wc3, tau3] = wideband_beamform(Nt, K, x(i_u), y(i_u), fc);
        Wa3(:, i_u, :) = GenerateComBeam(wc3, tau3, f);
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd3 = pinv(Hm.'* Wa3(:, :, m));
         Wh3 = Wa3(:,:,m) * Wd3;
         Wh3 = sqrt(Pt) * Wh3 / norm(Wh3(:)); 
         Rate3(iter, idx) = Rate3(iter, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh3*Wh3')*conj(Hm))*SNR* Nt)))/M;
    end
     
    
    %% ALTMin
    Wa4 = AltMin(W0, Nt, Nu, Nu);
    Wa4 = sqrt(Nu)*Wa4/norm(Wa4(:));
    for m=1:M
         Hm = H(:,:,m);
         Wd4 = pinv(Hm.'* Wa4);
         Wh4 = Wa4 * Wd4;
         Wh4 = sqrt(Pt) * Wh4 / norm(Wh4(:)); 
         Rate4(iter, idx) = Rate4(iter, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh4*Wh4')*conj(Hm))*SNR* Nt)))/M;
     end

    %% narrow focus
    Wa1 = zeros(Nt, Nu);
    for i_u = 1:Nu
        Wa1(:, i_u) = narrow_focus( Hc(:, i_u).', Nt);
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd1 = pinv(Hm.'* Wa1);
         Wh1 = Wa1 * Wd1;
         Wh1 = sqrt(Pt) * Wh1 / norm(Wh1(:)); 
         Rate1(iter, idx) = Rate1(iter, idx) + real(log2(det(eye(Nu) + (Hm.'*(Wh1*Wh1')*conj(Hm))*SNR* Nt)))/M;
    end
     
    end
end

%% Average on all random experiments
Rate0= mean(Rate0, 1);  
Rate1= mean(Rate1, 1);
Rate2= mean(Rate2, 1);
Rate3= mean(Rate3, 1);
Rate4= mean(Rate4, 1);


%% visualization
index_num = Nt_len;
figure; hold on; grid on;box on;
m = 1;
p2 = plot(Nt_list(1:m:end), Rate2(1:m:end), '-o','Linewidth',1.2, 'color',[217,83,25]/256);
p3 = plot(Nt_list(1:m:end), Rate3(1:m:end), '-s','Linewidth',1.2, 'color',[237,177,32]/256);
p4 = plot(Nt_list(1:m:end), Rate4(1:m:end), '-d','Linewidth',1.2, 'color',[126,47,142]/256);
p1 = plot(Nt_list(1:m:end), Rate1(1:m:end), '-^','Linewidth',1.2, 'color',[119,172,48]/256);
p0 = plot(Nt_list(1:m:end), Rate0(1:m:end), '--','Linewidth',1.5, 'color',[0,114,189]/256);
xlim([min(Nt_list), max(Nt_list)])


l3 = legend([p0,p2,p3,p4,p1], {'Full-TTD','Proposed PDF',  ...
    'TTD-DPP','PE-AltMin', 'Beamfocusing'});
l1 = xlabel('The number of antennas');
l2 = ylabel('Average Rate [bit/s/Hz]');
% xlim([min(Nt_list),256])
set(l1, 'Fontsize', 12, 'FontName', 'Times','Interpreter','latex');
set(l2, 'Fontsize', 12, 'FontName', 'Times','Interpreter','latex');
set(l3, 'Fontsize', 10, 'FontName', 'Times','Interpreter','latex');
