clear all;  clc;
Nt = 256;  % Number of antennas 
Nu = 4;    % Number of users 
K = 8;     % Number of TTDs
P = 32;    % Number of sub-array antennas
fc = 100e9; % carrier frequency
c = 3e8;
lambda_c = c/fc;
d = lambda_c / 2;
B = 0.05*fc;  %bandwidth
M = 128;      %number of subcarriers
f = zeros(M,1);
for m =1:M
   f(m) = fc+B/(M)*(m-1-(M-1)/2);
end

Pt = 4;   % Transmission power

SNR_dB= -5:1:15;
SNR = 10.^(SNR_dB/10.);


R_min = 1;  % min distance
R_max = 30; % max distance
theta_min = -pi/3; % min angle
theta_max = pi/3;  % max angle


N_iter = 50;
Rate0=zeros(1,length(SNR));
Rate1=zeros(1,length(SNR));
Rate2=zeros(1,length(SNR));
Rate3=zeros(1,length(SNR));
Rate4=zeros(1,length(SNR));

for iter = 1:N_iter
    iter
    [H, Hc, x, y] = near_Multipath_channel(Nt,Nu, d,fc, B, M, R_min, R_max, theta_min, theta_max);

   %% optimal 
    W0 = zeros(Nt, Nu, M);  % beamforming vector
    for m = 1:M
       Hm = H(:,:,m);
       Wm0 = pinv(Hm.'); 
       Wm0 = sqrt(Pt) * Wm0 / norm(Wm0(:));
       W0(:, :, m) = Wm0;
       for i_snr = 1:length(SNR)
         Rate0(i_snr) = Rate0(i_snr) + real(log2(det(eye(Nu) + (Hm.'*(Wm0*Wm0')*conj(Hm))*SNR(i_snr))))/M/N_iter;
       end
    end


    


    %% wideband bessel
    Wa2 = zeros(Nt, Nu, M); % beamforming vector
    for i_u = 1:Nu
        [wc2, tau2] = wideband_bessel(Nt, K, x(i_u), y(i_u), fc, d);
        w2 = GenerateComBeam(wc2, tau2, f);
        for m = 1:M
            Wa2(:, i_u, m) = w2(:, m); 
        end
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd2 = pinv(Hm.'* Wa2(:, :, m));
         Wh2 = Wa2(:,:,m) * Wd2;
         Wh2 = sqrt(Pt) * Wh2 / norm(Wh2(:)); 
         for i_snr = 1:length(SNR)
             Rate2(i_snr) = Rate2(i_snr) + real(log2(det(eye(Nu) + (Hm.'*(Wh2*Wh2')*conj(Hm))*SNR(i_snr))))/M/N_iter;
         end
     end

    %% wideband beamforming
    Wa3 = zeros(Nt, Nu, M); % beamforming vector
    for i_u = 1:Nu
        [wc3, tau3] = wideband_beamform(Nt, K, x(i_u), y(i_u), fc);
        Wa3(:, i_u, :) = GenerateComBeam(wc3, tau3, f);
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd3 = pinv(Hm.'* Wa3(:, :, m));
         Wh3 = Wa3(:,:,m) * Wd3;
         Wh3 = sqrt(Pt) * Wh3 / norm(Wh3(:)); 
         for i_snr = 1:length(SNR)
             Rate3(i_snr) = Rate3(i_snr) + real(log2(det(eye(Nu) + (Hm.'*(Wh3*Wh3')*conj(Hm))*SNR(i_snr))))/M/N_iter;
         end
     end



    %% ALTMin
    Wa4 = AltMin(W0, Nt, Nu, Nu); % beamforming vector
    Wa4 = sqrt(Nu)*Wa4/norm(Wa4(:));
    for m=1:M
         Hm = H(:,:,m);
         Wd4 = pinv(Hm.'* Wa4);
         Wh4 = Wa4 * Wd4;
         Wh4 = sqrt(Pt) * Wh4 / norm(Wh4(:)); 
         for i_snr = 1:length(SNR)
             Rate4(i_snr) = Rate4(i_snr) + real(log2(det(eye(Nu) + (Hm.'*(Wh4*Wh4')*conj(Hm))*SNR(i_snr))))/M/N_iter;
         end
     end
    
    %% narrow focus
    Wa1 = zeros(Nt, Nu);
    for i_u = 1:Nu
        Wa1(:, i_u) = narrow_focus( Hc(:, i_u).', Nt);
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd1 = pinv(Hm.'* Wa1);
         Wh1 = Wa1 * Wd1;
         Wh1 = sqrt(Pt) * Wh1 / norm(Wh1(:)); 
         for i_snr = 1:length(SNR)
             Rate1(i_snr) = Rate1(i_snr) + real(log2(det(eye(Nu) + (Hm.'*(Wh1*Wh1')*conj(Hm))*SNR(i_snr))))/M/N_iter;
         end
     end
end
%% visualization



figure; hold on; grid on;box on;
p0 = plot(SNR_dB, Rate0,  '--','Linewidth',1.2, 'color',[0,114,189]/256);
p2 = plot(SNR_dB, Rate2 , '-o','Linewidth',1.2, 'color',[217,83,25]/256);
p3 = plot(SNR_dB, Rate3 , '-s','Linewidth',1.2, 'color',[237,177,32]/256);
p4 = plot(SNR_dB, Rate4 , '-d','Linewidth',1.2, 'color',[126,47,142]/256);
p1 = plot(SNR_dB, Rate1 , '-^','Linewidth',1.2, 'color',[119,172,48]/256);

l1 = xlabel('SNR [dB]'); 
l2 = ylabel('Average Rate [bit/s/Hz]');
l3 = legend([p0,p2,p3,p4,p1], {'Full-TTD','Proposed PDF',  ...
    'TTD-DPP','PE-AltMin', 'Beamfocusing'});
set(l1, 'Fontsize', 12, 'FontName', 'Times');
set(l2, 'Fontsize', 12, 'FontName', 'Times');
set(l3, 'Fontsize', 10, 'FontName', 'Times');


