clear all;  clc;
Nt = 256; % number of antennas
Nu = 1;   % number of users
fc = 100e9;  % carrier frequency
c = 3e8;
lambda_c = c/fc;
d = lambda_c / 2;  % antenna spacing
B = 5e9;  % bandwidth
M = 128;  % subcarrier number
f = zeros(M,1);  % subcarrier frequency
for m =1:M
   f(m) = fc+B/(M)*(m-1-(M-1)/2);
end

Pt = 1; % transmission power
SNR_dB= 10;
SNR = 10.^(SNR_dB/10.);
K = 8;  % subarray number
P = 32; % subarray antenna number
theta_min = pi/8;
theta_max = pi/8;

dis = linspace(1, 100, 200);
Rate0 =zeros(1,length(dis));
Rate1=zeros(1,length(dis));
Rate2=zeros(1,length(dis));
Rate3=zeros(1,length(dis));
Rate4=zeros(1,length(dis));
Rate5=zeros(1,length(dis));
theta = pi/8;

    
for iter = 1:length(dis)
    iter

    R_min = dis(iter);
    R_max = dis(iter);

   [H, Hc, x, y] = near_Multipath_channel(Nt,Nu, d,fc, B, M, R_min, R_max, theta_min, theta_max);

      %% optimal 
        W0 = zeros(Nt, Nu, M);
        for m = 1:M
            Hm = H(:,:,m);
            Wm0 = pinv(Hm.'); 
            Wm0 = sqrt(Pt) * Wm0 / norm(Wm0(:));
            W0(:, :, m) = Wm0;
            Rate0(iter) = Rate0(iter) + real(log2(det(eye(Nu) + (Hm.'*(Wm0*Wm0')*conj(Hm))*SNR)))/M;
        end




    %% wideband bessel
    Wa2 = zeros(Nt, Nu, M);
    for i_u = 1:Nu
        [wc2, tau2] = wideband_bessel(Nt, K, x(i_u), y(i_u), fc, d);
        w2 = GenerateComBeam(wc2, tau2, f);
        for m = 1:M
            Wa2(:, i_u, m) = w2(:, m); 
        end
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd2 = pinv(Hm.'* Wa2(:, :, m));
         Wh2 = Wa2(:,:,m) * Wd2;
         Wh2 = sqrt(Pt) * Wh2 / norm(Wh2(:)); 
         Rate2(iter) = Rate2(iter) + real(log2(det(eye(Nu) + (Hm.'*(Wh2*Wh2')*conj(Hm))*SNR)))/M;
     end

    %% wideband beamforming
    Wa3 = zeros(Nt, Nu, M);
    for i_u = 1:Nu
        [wc3, tau3] = wideband_beamform(Nt, K, x(i_u), y(i_u), fc);
        Wa3(:, i_u, :) = GenerateComBeam(wc3, tau3, f);
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd3 = pinv(Hm.'* Wa3(:, :, m));
         Wh3 = Wa3(:,:,m) * Wd3;
         Wh3 = sqrt(Pt) * Wh3 / norm(Wh3(:)); 
         Rate3(iter) = Rate3(iter) + real(log2(det(eye(Nu) + (Hm.'*(Wh3*Wh3')*conj(Hm))*SNR)))/M;
    end
     
    
    %% ALTMin
    Wa4 = AltMin(W0, Nt, Nu, Nu);
    Wa4 = sqrt(Nu)*Wa4/norm(Wa4(:));
    for m=1:M
         Hm = H(:,:,m);
         Wd4 = pinv(Hm.'* Wa4);
         Wh4 = Wa4 * Wd4;
         Wh4 = sqrt(Pt) * Wh4 / norm(Wh4(:)); 
         Rate4(iter) = Rate4(iter) + real(log2(det(eye(Nu) + (Hm.'*(Wh4*Wh4')*conj(Hm))*SNR)))/M;
     end

    %% narrow focus
    Wa1 = zeros(Nt, Nu);
    for i_u = 1:Nu
        Wa1(:, i_u) = narrow_focus( Hc(:, i_u).', Nt);
    end
    for m=1:M
         Hm = H(:,:,m);
         Wd1 = pinv(Hm.'* Wa1);
         Wh1 = Wa1 * Wd1;
         Wh1 = sqrt(Pt) * Wh1 / norm(Wh1(:)); 
         Rate1(iter) = Rate1(iter) + real(log2(det(eye(Nu) + (Hm.'*(Wh1*Wh1')*conj(Hm))*SNR)))/M;
    end
    
   

end
%% visualization
D = (Nt - 1) * d;
ERD = D^2 / 2 / lambda_c / 0.8257^2 * cos(theta)^2;
RD = D^2 * 2 / lambda_c;

C = linspecer(6);


figure1 = figure; hold on; grid on;box on;
markernum = 30;
p2 = Plot(dis, Rate2, markernum, '-o','Linewidth',1.2, 'color',[217,83,25]/256);
p3 = Plot(dis, Rate3, markernum, '-s','Linewidth',1.2, 'color',[237,177,32]/256);
p4 = Plot(dis, Rate4, markernum, '-d','Linewidth',1.2, 'color',[126,47,142]/256);
p1 = Plot(dis, Rate1, markernum, '-^','Linewidth',1.2, 'color',[119,172,48]/256);
p0 = plot(dis, Rate0, '--','Linewidth',1.5, 'color',[0,114,189]/256);
plot(ones(100,1)*ERD, linspace(0, max(Rate0+1)), 'r--', 'Linewidth', 1.5);
plot(ones(100,1)*RD, linspace(0, max(Rate0+1)), 'b--', 'Linewidth', 1.5);



xlim([0, max(dis)]);
ylim([0, max(Rate0+0.5)])
set(gca,'XDir','reverse')


l1 = xlabel('Distance [m]');
l2 = ylabel('Average Rate [bit/s/Hz]');
l3 = legend([p0,p2,p3,p4,p1], {'Full-TTD','Proposed PDF',  ...
    'TTD-DPP','PE-AltMin', 'Beamfocusing'});
set(l1, 'Fontsize', 12, 'FontName', 'Times','Interpreter','latex');
set(l2, 'Fontsize', 12, 'FontName', 'Times','Interpreter','latex');
set(l3, 'Fontsize', 10, 'FontName', 'Times','Interpreter','latex');


% 创建 arrow
annotation(figure1,'arrow',[0.55 0.668571428571428],...
    [0.389476190476191 0.390476190476191],'Color',[1 0 0]);

% 创建 arrow
annotation(figure1,'arrow',[0.254285714285714 0.15],...
    [0.666666666666667 0.666666666666667],'Color',[0 0 1]);

% 创建 textbox
annotation(figure1,'textbox',...
    [0.246714285714285 0.635714285714289 0.231857142857143 0.0628571428571431],...
    'Color',[0 0 1],...
    'String','Rayleigh distance',...
    'FontSize',12,...
    'FontName','Times',...
    'FitBoxToText','off',...
    'EdgeColor','none');

% 创建 textbox
annotation(figure1,'textbox',...
    [0.215 0.360476190476192 0.363928571428571 0.0628571428571429],...
    'Color',[1 0 0],...
    'String','Effective Rayleigh distance',...
    'FontSize',12,...
    'FontName','Times',...
    'FitBoxToText','off',...
    'EdgeColor','none');

