function [w, tau] = wideband_beamform(Nt, K, x,y,  fc)
c = 3e8;
d = c/fc/2;
theta0 = atan((y - (Nt-1)/2*d)/x);
P = Nt/K;


w = zeros(Nt, 1);
for idx = 0:K-1
temp = exp(1j*pi*sin(theta0)*(idx*P + (P-1)/2)) * exp( -1j*pi*sin(theta0)*(idx*P + (0:P-1)') )/sqrt(Nt);
    w( idx*P + 1 : (idx + 1 )*P ) = temp;
end

tau =  0.5/fc*sin(theta0)*((0:K-1)*P + (P-1)/2);
end

