function [w, tau] = wideband_bessel(Nt, K, x,y, fc, d)
nn = 0:1:Nt-1;
L = sqrt(x.^2 + (y - nn.*d).^2);
theta = atan((y- nn.*d)./x);

P = Nt/K;
c = 3e8;
index = ceil(P/2) + (0:K-1)*P;
theta = theta(index);
L = L(index);
nn = (-(ceil(P/2)-1):1:floor(P/2))';

w = zeros(Nt, 1);
for idx = 1:K
temp = exp(1j*pi*sin(theta(idx))/2) * exp(-1j*2*pi*fc*d*sin(theta(idx))*nn/c)/sqrt(Nt);
    w( (idx-1)*P + 1 : idx*P ) = temp;
end

tau = sin(theta)/4/fc - L/c;
% tau =  - L/c;
end

