function [w, tau] = wideband_focus(Nt, K, x, y , fc)
nn = 0:1:Nt-1;
L = sqrt(x.^2 + (y - nn.*d).^2);
P = Nt/K;
c = 3e8;
index = ceil(P/2) + (0:K-1)*P;
Lc = L(index);


w = zeros(Nt, 1);
for idx = 1:K
temp = exp( -1j*2*pi*fc*  ( Lc(idx) - L((idx-1)*P + 1 : idx*P) )/c    ) /sqrt(Nt);
    w( (idx - 1) * P + 1 : idx*P ) = temp;
end

tau =  - Lc/c;
end

